package com.openexchange.office.tools.common.parser;

import java.util.HashSet;
import java.util.Set;

public class CharMatcher {

	public static Set<String> findAllMatches(byte[] stream, byte[] pattern, char endChar, int reusePatternParts) {
		final HashSet<String> ids = new HashSet<String>();
		findAllMatches(stream, pattern, endChar, ids, reusePatternParts);
		return ids;
	}

	public static void findAllMatches(byte[] stream, byte[] pattern, char endChar, Set<String> ids, int reusePatternParts) {

		// searching and collecting each pattern
		int index = 0;
		do {
			index = indexOfBytes(stream, pattern, index);
			if (index != -1) {
				// we found a pattern
				index += pattern.length;
				int length = 0;
				while (index < stream.length && stream[index] != endChar) {
					length++;
					index++;
				}
				if (length != 0) {
					length += reusePatternParts;
					ids.add(new String(stream, index - length, length));
				}
			}
		} while (index != -1);
	}

	public static int indexOfBytes(byte[] array, byte[] pattern, int index) {
		int ident = 0;
		while (index < array.length) {
			ident = (array[index] == pattern[ident]) ? ++ident : 0;
			if (ident == pattern.length) {
				return index - ident + 1;
			}
			index++;
		}
		return -1;
	}
}
