/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.rest.operations;

import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.office.rest.GetOperationsAction;
import com.openexchange.office.rest.job.Job;
import com.openexchange.office.tools.osgi.ServiceLookupRegistry;
import com.openexchange.tools.session.ServerSession;

public class GetOperationsJob extends Job {

    // ---------------------------------------------------------------
    private final ServerSession session;

    // ---------------------------------------------------------------
    private String folderId;

    // ---------------------------------------------------------------
    private String fileId;

    // ---------------------------------------------------------------
    private String version;

    // ---------------------------------------------------------------
    public GetOperationsJob(final ServerSession session, String folderId, String fileId, String version) {
        this.session = session;
        this.folderId = folderId;
        this.fileId = fileId;
        this.version = version;
    }

    // ---------------------------------------------------------------
    @Override
    public boolean execute() throws Exception {
        final IDBasedFileAccess fileAccess = ServiceLookupRegistry.get().getService(IDBasedFileAccessFactory.class).createAccess(session);
        final String            hash       = fileAccess.getFileMetadata(fileId, version).getFileMD5Sum();
        final OperationsResult  aResult    = GetOperationsAction.getOperationsFromDocument(fileAccess, session, folderId, fileId, version, "");

        if (aResult.getErrorCode().isNoError()) {
            final String        aEntryKey = OperationDataCache.getKeyFromProps(fileId, version, session.getContextId());
            final OperationData aData     = new OperationData(aEntryKey, hash, aResult.getHtmlDoc(), aResult.getPreviewData(), aResult.getOperations());

            OperationDataCache.getInstance().put(aEntryKey, aData);
        }

        return aResult.getErrorCode().isNoError();
    }

}
