/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.message;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.realtime.packet.ID;

/**
 * {@link MessageChunk}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class MessageChunk {

    public static final String MSGCHUNK_ID = "id";
    public static final String MSGCHUNK_ACTION = "action";

    private JSONObject m_actions;
    private String m_id;
    private ID m_sender;

    /**
     * Initializes a new {@link MessageChunk}.
     *
     * @param operations
     * @param sender
     */
    public MessageChunk() {
        super();
    }

    /**
     * Initializes a new {@link MessageChunk}.
     *
     * @param jsonObject
     * @param sender
     */
    public MessageChunk(final JSONObject messages, final ID sender) {
        super();

        try {
            final JSONArray wrappedActions = messages.optJSONArray(MSGCHUNK_ACTION);

            if (null != wrappedActions) {
                m_actions = new JSONObject();
                m_actions.put(MessagePropertyKey.KEY_ACTIONS, wrappedActions);
                m_id = messages.optString(MSGCHUNK_ID);
            } else {
                // non-wrapped message
                m_actions = messages;
            }
        } catch (final JSONException e) {
            // TODO: log error, if non-compatible format
        }

        this.m_sender = sender;
    }

    /**
     * @return
     */
    public JSONObject getOperations() {
        return m_actions;
    }

    public final String getUuid() {
        return m_id;
    }

    /**
     * @return
     */
    public ID getSender() {
        return m_sender;
    }

    /**
     * @param sender
     */
    public JSONObject toJSON() {
        final JSONObject ret = new JSONObject();

        try {
            if ((null != m_actions) && m_actions.has("actions")) {
                ret.put("actions", m_actions.getJSONArray("actions"));
            }

            if (null != m_sender) {
                ret.put("sender", m_sender.toString());
            }
        } catch (JSONException e) {
            //
        }

        return ret;
    }

    static public MessageChunk createFrom(JSONObject jsonData, ID _sender) {
        JSONObject actions = null;
        ID sender = _sender;

        if (null != jsonData) {
            try {
                if (jsonData.has(MessagePropertyKey.KEY_ACTIONS)) {
                    actions = new JSONObject();
                    actions.put(MessagePropertyKey.KEY_ACTIONS, jsonData.getJSONArray(MessagePropertyKey.KEY_ACTIONS));
                }

                if ((null == sender) && jsonData.has(MessagePropertyKey.KEY_SENDER)) {
                    sender = new ID(jsonData.getString(MessagePropertyKey.KEY_SENDER));
                }
            } catch (JSONException e) {
                //
            }
        }

        return ((null != actions) || (null != sender)) ? new MessageChunk(actions, sender) : null;
    }

}
