/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.htmldoc;

import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.api.OCValue;

public class OperationReducer
{
	private final static Logger	LOG	= LoggerFactory.getLogger(OperationReducer.class);

	static public void reduceOperationCount(
		JSONObject documentOperations)
	{

		try
		{
			final long time = System.currentTimeMillis();
			final JSONArray ops = documentOperations.getJSONArray("operations");
			final int opCount = ops.length();

			for (int i = 0; i < ops.length(); i++)
			{
				final JSONObject op = ops.getJSONObject(i);
				final String opName = op.getString(OCKey.NAME.value());
				if (opName.equals(OCValue.INSERT_PARAGRAPH.value()))
				{
					int next = i + 1;
					final JSONObject nextOp = ops.optJSONObject(next);
					if (nextOp == null)
					{
						break;
					}
					final JSONArray currentStart = op.getJSONArray(OCKey.START.value());
					if (nextOp.getString(OCKey.NAME.value()).equals(OCValue.SET_ATTRIBUTES.value()))
					{
						final JSONArray nextStart = nextOp.getJSONArray(OCKey.START.value());
						if (nextStart.isEqualTo(currentStart))
						{
							next++;
						}
					}

					i = handleParagraphAndFollows(next, op, ops);
				}
			}

			LOG.debug("RT connection: Reduction of operation count took " + (System.currentTimeMillis() - time) + "ms ops before " + opCount + " ops after " + ops.length());
		}
		catch (final Exception e)
		{
			LOG.warn("RT connection: Exception while reducing operation count", e);
		}
	}

	private static int handleParagraphAndFollows(
		int i,
		JSONObject paraOp,
		JSONArray ops)
		throws Exception
	{

		final JSONArray paraPos = paraOp.getJSONArray(OCKey.START.value());

		final Paragraph myPara = new Paragraph();

		int max = ops.length();

		for (int j = i; j < ops.length(); j++)
		{
			final JSONObject op = ops.getJSONObject(j);
			final JSONArray start = op.optJSONArray(OCKey.START.value());

			if (start == null || start.length() != paraPos.length() + 1)
			{
				max = j;
				break;
			}

			for (int k = 0; k < paraPos.length(); k++)
			{
				if (paraPos.getInt(k) != start.getInt(k))
				{
					max = j;
					break;
				}
			}

			if (max == j)
			{
				break;
			}

			final String opName = op.getString(OCKey.NAME.value());

			if (opName.equals(OCValue.SET_ATTRIBUTES.value()))
			{
				final JSONObject attrs = op.optJSONObject(OCKey.ATTRS.value());
				final JSONArray end = op.optJSONArray(OCKey.END.value());
				final JSONArray myStart = makeJSONARRAY(start.get(start.length() - 1));
				final JSONArray myEnd;
				if (end != null)
				{
					myEnd = makeJSONARRAY(end.get(end.length() - 1));
				}
				else
				{
					myEnd = myStart;
				}

				myPara.setAttribute(myStart, myEnd, attrs);
			}
			else
			{
				final INode insert;
				if (opName.equals(OCValue.INSERT_TEXT.value()))
				{
					final int textIndex = start.getInt(start.length() - 1);
					final String text = op.getString(OCKey.TEXT.value());
					insert = new Text(text, textIndex);
				}
				else if (opName.equals(OCValue.INSERT_TAB.value()))
				{
					final int textIndex = start.getInt(start.length() - 1);
					insert = new Tab(textIndex);
				}
				else if (opName.equals(OCValue.INSERT_HARD_BREAK.value()))
				{
					final int textIndex = start.getInt(start.length() - 1);
					final String type = op.optString(OCKey.TYPE.value());
					insert = new HardBreak(textIndex, type);
				}
				else
				{
					LOG.info(opName + " nr: " + j + " not implemented yet");
					//continue;
					return max - 1;
				}
				myPara.insert(new JSONArray(), insert);

			}

		}

		final List<JSONObject> reducedOps = myPara.getReducedOps(paraPos);
		if (reducedOps != null)
		{

			final int reduzedSize = reducedOps.size();

			for (int j = 0; j < reduzedSize; j++)
			{
				ops.put(i + j, reducedOps.get(j));
			}

			for (int j = i + reduzedSize; j < max; j++)
			{
				ops.remove(i + reduzedSize);
			}

			max = i + reduzedSize;
		}

		return max - 1;
	}

	private static JSONArray makeJSONARRAY(
		Object... objects)
	{
		final JSONArray res = new JSONArray();
		for (final Object obj : objects)
		{
			res.put(obj);
		}
		return res;
	}
}
