/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.docx.components;

import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.mce.AlternateContent;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTObject;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.DelInstrText;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.IText;
import org.docx4j.wml.InstrText;
import org.docx4j.wml.Pict;
import org.docx4j.wml.R;
import org.docx4j.wml.R.Tab;
import org.docx4j.wml.STFldCharType;
import com.openexchange.office.filter.ooxml.components.Component;
import com.openexchange.office.filter.ooxml.components.ComponentContext;

public class TextRunContext extends ComponentContext {

    public TextRunContext(ComponentContext p, IndexedNode<Object> n) {
        super(p, n);
    }

    @Override
    public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        final IndexedNode<Object> textRunNode = getNode();
        final IndexedNodeList<Object> nodeList = (IndexedNodeList<Object>)((ContentAccessor)textRunNode.getData()).getContent();
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;
        IndexedNode<Object> childNode = previousChildContext!=null ? nodeList.getNextNode(previousChildContext.getNode()) : nodeList.getFirstNode();

        TextRun_Base nextComponent = null;
        for(; nextComponent==null&&childNode!=null; childNode = nodeList.getNextNode(childNode)) {
            final Object o = Component.getContentModel(childNode, textRunNode.getData());
            if(o instanceof IText) {
                if(((IText)o).getValue().length()>0) {
                    nextComponent = new TextComponent(this, childNode, nextComponentNumber);
                }
            }
            else if(o instanceof AlternateContent)
                nextComponent = new AlternateContentComponent(this, childNode, nextComponentNumber);
            else if(o instanceof Drawing)
                nextComponent = new DrawingComponent(this, childNode, nextComponentNumber);
            else if(o instanceof Pict||o instanceof CTObject)
                nextComponent = new PictVMLComponent(this, childNode, nextComponentNumber);
            else if(o instanceof Tab)
                nextComponent = new TabComponent(this, childNode, nextComponentNumber);
            else if(o instanceof Br)
                nextComponent = new HardBreakComponent(this, childNode, nextComponentNumber);
            else if(o instanceof R.CommentReference)
            	nextComponent = new CommentReferenceComponent(this, childNode, nextComponentNumber);
            else if(o instanceof FldChar) {
                final STFldCharType fldCharType = ((FldChar)o).getFldCharType();
                if(STFldCharType.BEGIN==fldCharType) {
                    nextComponent = new FldCharBegin(this, childNode, nextComponentNumber);
                }
                else if(STFldCharType.SEPARATE==fldCharType) {
                    nextComponent = new FldCharSeparate(this, childNode, nextComponentNumber, previousChildComponent instanceof FldCharBegin ? (FldCharBegin)previousChildComponent : null);
                }
                else if(STFldCharType.END==fldCharType) {
                    nextComponent = new FldCharEnd(this, childNode, nextComponentNumber);
                }
            }
            else if((o instanceof InstrText||o instanceof DelInstrText)&&previousChildComponent instanceof FldCharBegin) {
                ((FldCharBegin)previousChildComponent).getInstructionNodes().add(childNode);
            }
        }
        return nextComponent;
    }
}
