/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ods.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xml.serializer.SerializationHandler;
import org.json.JSONArray;
import org.json.JSONException;
import org.odftoolkit.odfdom.IElementWriter;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.SaxContextHandler;
import com.openexchange.office.filter.odf.styles.StyleManager;
import com.openexchange.office.filter.ods.dom.SmlUtils.CellRefRange;

@SuppressWarnings("serial")
public class ContentValidations extends ElementNSImpl implements IElementWriter {

	private final HashMap<Integer, List<ContentValidation>> contentValidationsByHash = new HashMap<Integer, List<ContentValidation>>();
	private final HashMap<String, ContentValidation> contentValidationsByName = new HashMap<String, ContentValidation>();
	private final HashSet<String> usedValidations = new HashSet<String>();

	public ContentValidations(OdfFileDom ownerDocument)
		throws DOMException {
		super(ownerDocument, Namespaces.TABLE, "table:content-validations");
	}

	public ContentValidation getContentValidationByName(String n) {
	    return contentValidationsByName.get(n);
	}

	public ContentValidation getExistingContentValidation(ContentValidation v) {
	    final List<ContentValidation> validations = contentValidationsByHash.get(v.hashCode());
	    if(validations!=null) {
	        for(ContentValidation validation:validations) {
	            if(validation.equals(v)) {
	                return validation;
	            }
	        }
	    }
	    return null;
	}

	public HashSet<String> getUsedValidations() {
	    return usedValidations;
	}

	public ContentValidation addValidation(ContentValidation contentValidation, boolean checkForExistingValidation) {
	    if(checkForExistingValidation) {
	        final ContentValidation existingValidation = getExistingContentValidation(contentValidation);
	        if(existingValidation!=null) {
	            return existingValidation;
	        }
	        // we have to insert a new validation using a unique name;
            int rnd = StyleManager.getRandom();
            while(true) {
                final String newValidationName = Integer.valueOf(rnd++).toString();
                if(!contentValidationsByName.containsKey(newValidationName)) {
                    contentValidation.setName(newValidationName);
                    break;
                }
            }
	    }
	    else if(contentValidationsByName.containsKey(contentValidation.getName())) {
	        return null;
	    }
	    final int key = contentValidation.hashCode();
	    List<ContentValidation> contentValidationList = contentValidationsByHash.get(key);
	    if(contentValidationList==null) {
	        contentValidationList = new ArrayList<ContentValidation>();
	        contentValidationsByHash.put(key, contentValidationList);
	    }
	    contentValidationList.add(contentValidation);
	    contentValidationsByName.put(contentValidation.getName(), contentValidation);
	    usedValidations.add(contentValidation.getName());
	    return contentValidation;
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		if(!contentValidationsByName.isEmpty()) {
			output.startElement(getNamespaceURI(), getLocalName(), getNodeName());
			SaxContextHandler.addAttributes(output, getAttributes(), null);
			final Iterator<ContentValidation> contentValidationIter = contentValidationsByName.values().iterator();
			while(contentValidationIter.hasNext()) {
			    final ContentValidation contentValidation = contentValidationIter.next();
			    if(usedValidations.contains(contentValidation.getName())) {
			        contentValidation.writeObject(output);
			    }
			}
			output.endElement(getNamespaceURI(), getLocalName(), getNodeName());
		}
	}

    public static void createContentValidations(SpreadsheetContent content, JSONArray operationQueue, int sheetIndex, List<Pair<SmlUtils.CellRefRange, String>> contentValidations)
        throws JSONException {

        final HashMap<String, List<SmlUtils.CellRefRange>> ranges = new HashMap<String, List<SmlUtils.CellRefRange>>();
        for(Pair<SmlUtils.CellRefRange, String> entry:contentValidations) {
            List<SmlUtils.CellRefRange> rangeList = ranges.get(entry.getRight());
            if(rangeList==null) {
                rangeList = new ArrayList<SmlUtils.CellRefRange>();
                ranges.put(entry.getRight(), rangeList);
            }
            rangeList.add(entry.getLeft());
        }
        for(Entry<String, List<CellRefRange>> validation:ranges.entrySet()) {
            ContentValidation.createContentValidation(content, operationQueue, sheetIndex, validation.getKey(), validation.getValue());
        }
    }
}
