/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ods.dom;

import org.apache.xml.serializer.SerializationHandler;
import org.xml.sax.SAXException;

import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.SaxContextHandler;

// This class is containing cell attributes that are rarely used

public class CellAttributesEnhanced {

	private String contentValidationName;
	private String numberMatrixRowsSpanned;
	private String numberMatrixColumnsSpanned;
	private String protect;
	private String protectedC;
	
	public CellAttributesEnhanced() {
		contentValidationName = null;
		numberMatrixRowsSpanned = null;
		numberMatrixColumnsSpanned = null;
		protect = null;
		protectedC = null;
	}

	public String getContentValidationName() {
		return contentValidationName;
	}
	public void setContentValidationName(String contentValidationName) {
		this.contentValidationName = contentValidationName;
	}
	public String getNumberMatrixRowsSpanned() {
		return numberMatrixRowsSpanned;
	}
	public void setNumberMatrixRowsSpanned(String numberMatrixRowsSpanned) {
		this.numberMatrixRowsSpanned = numberMatrixRowsSpanned;
	}
	public String getNumberMatrixColumnsSpanned() {
		return numberMatrixColumnsSpanned;
	}
	public void setNumberMatrixColumnsSpanned(String numberMatrixColumnsSpanned) {
		this.numberMatrixColumnsSpanned = numberMatrixColumnsSpanned;
	}
	public String getProtect() {
		return protect;
	}
	public void setProtect(String protect) {
		this.protect = protect;
	}
	public String getProtected() {
		return protectedC;
	}
	public void setProtected(String protectedC) {
		this.protectedC = protectedC;
	}
	public void writeAttributes(SerializationHandler output)
		throws SAXException {

		if(contentValidationName!=null) {
        	SaxContextHandler.addAttribute(output, Namespaces.TABLE, "content-validation-name", "table:content-validation-name", contentValidationName);
		}
		if(numberMatrixRowsSpanned!=null) {
			SaxContextHandler.addAttribute(output, Namespaces.TABLE, "number-matrix-rows-spanned", "table:number-matrix-rows-spanned", numberMatrixRowsSpanned);
		}
		if(numberMatrixColumnsSpanned!=null) {
			SaxContextHandler.addAttribute(output, Namespaces.TABLE, "number-matrix-columns-spanned", "table:number-matrix-columns-spanned", numberMatrixColumnsSpanned);
		}
		if(protect!=null) {
			SaxContextHandler.addAttribute(output, Namespaces.TABLE, "protect", "table:protect", protect);
		}
		if(protectedC!=null) {
			SaxContextHandler.addAttribute(output, Namespaces.TABLE, "protected", "table:protected", protectedC);
		}
	}
}
