/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odp.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.odf.DLList;
import com.openexchange.office.filter.odf.Decl;
import com.openexchange.office.filter.odf.INodeAccessor;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.SaxContextHandler;

public class Presentation extends ElementNSImpl implements IElementWriter, INodeAccessor {

	private static final long serialVersionUID = 1L;

	private DLList<Object> pages;

	HashMap<String, Decl> footerDecls;
    HashMap<String, Decl> headerDecls;
    HashMap<String, Decl> dateTimeDecls;
	
	public Presentation(OdfFileDom ownerDocument, Attributes attributes) {
		super(ownerDocument, Namespaces.OFFICE, "office:text");
	}

    @Override
    public DLList<Object> getContent() {
        if (pages == null) {
            pages = new DLList<Object>();
        }
        return pages;
    }

    public HashMap<String, Decl> getFooterDecls(boolean forceCreate) {
        if(footerDecls==null&&forceCreate) {
            footerDecls = new HashMap<String, Decl>();
        }
        return footerDecls;
    }

    public HashMap<String, Decl> getHeaderDecls(boolean forceCreate) {
        if(headerDecls==null&&forceCreate) {
            headerDecls = new HashMap<String, Decl>();
        }
        return headerDecls;
    }

    public HashMap<String, Decl> getDateTimeDecls(boolean forceCreate) {
        if(dateTimeDecls==null&&forceCreate) {
            dateTimeDecls = new HashMap<String, Decl>();
        }
        return dateTimeDecls;
    }

    /*
     * tries to get an existing decl key whose value equals the value parameter.
     * null if no decl can be found
     */
    public static Decl getDecl(HashMap<String, Decl> map, String value) {
        final Iterator<Entry<String, Decl>> iter = map.entrySet().iterator();
        while(iter.hasNext()) {
            final Entry<String, Decl> entry = iter.next();
            if(value.equals(entry.getValue().getValue())) {
                return entry.getValue();
            }
        }
        return null;
    }

    public static String getUniqueDeclKey(HashMap<String, Decl> map, String prefix) {
        Integer k = 1;
        while(true) {
            final String key = prefix + k.toString();
            if(map.get(key)==null) {
                return key;
            }
            k++;
        }
    }

    @Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		SaxContextHandler.startElement(output, Namespaces.OFFICE, "presentation", "office:presentation");
		if(footerDecls!=null) {
		    final Iterator<Decl> footerDeclIter = footerDecls.values().iterator();
		    while(footerDeclIter.hasNext()) {
		        footerDeclIter.next().writeObject(output);
		    }
		}
        if(headerDecls!=null) {
            final Iterator<Decl> headerDeclIter = headerDecls.values().iterator();
            while(headerDeclIter.hasNext()) {
                headerDeclIter.next().writeObject(output);
            }
        }
        if(dateTimeDecls!=null) {
            final Iterator<Decl> dateTimeDeclIter = dateTimeDecls.values().iterator();
            while(dateTimeDeclIter.hasNext()) {
                dateTimeDeclIter.next().writeObject(output);
            }
        }
		final Iterator<Object> pageIter = getContent().iterator();
		while(pageIter.hasNext()) {
		    ((IElementWriter)pageIter.next()).writeObject(output);
		}
		SaxContextHandler.endElement(output, Namespaces.OFFICE, "presentation", "office:presentation");
	}
}
