/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 *
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.components;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.odf.AttributeImpl;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.DLNode;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.OdfOperationDoc;
import com.openexchange.office.filter.odf.OpAttrs;
import com.openexchange.office.filter.odf.styles.NumberStyleBase;
import com.openexchange.office.filter.odf.styles.StyleBase;
import com.openexchange.office.filter.odf.styles.StyleFamily;
import com.openexchange.office.filter.odf.styles.StyleManager;
import com.openexchange.office.filter.odt.dom.TextField;

public class TextFieldComponent extends TextSpan_Base {

    public TextFieldComponent(ComponentContext parentContext, DLNode<Object> textFieldNode, int componentNumber) {
        super(parentContext, textFieldNode, componentNumber);
    }

    @Override
    public String simpleName() {
        return "Field";
    }

    @Override
    public void applyAttrsFromJSON(OdfOperationDoc operationDocument, JSONObject attrs)
            throws JSONException {

        final JSONObject character = attrs.optJSONObject(OCKey.CHARACTER.value());
        if(character!=null) {
            final JSONObject json = character.optJSONObject(OCKey.FIELD.value());
            if(json!=null) {
                final AttributesImpl attributes = ((TextField)getObject()).getAttributes();
                final Iterator<Entry<String, Object>> jsonIter = json.entrySet().iterator();
                final HashMap<String, String> additionalStyleProperties = new HashMap<String, String>();
                Object formatCode = null;
                while(jsonIter.hasNext()) {
                    final Entry<String, Object> jsonEntry = jsonIter.next();
                    if(jsonEntry.getValue() instanceof String) {
                        final String qName = jsonEntry.getKey();
                        if(qName.equals("dateFormat")) {
                            formatCode = jsonEntry.getValue();
                        }
                        else if(qName.equals("pageNumFormat")) {
                            if(jsonEntry.getValue() instanceof String) {
                                attributes.setValue(Namespaces.STYLE, "num-format", "style:num-format", (String)jsonEntry.getValue());
                            }
                        }
                        else if(qName.equals("number:automatic-order")) {
                            additionalStyleProperties.put("number:automatic-order", (String)jsonEntry.getValue());
                        }
                        else if(qName.equals("number:format-source")) {
                            additionalStyleProperties.put("number:format-source", (String)jsonEntry.getValue());
                        }
                        else {
                            final int index = qName.indexOf(':');
                            if(index>0&&qName.length()>index+1) {
                                final String prefix = qName.substring(0, index);
                                final String localName = qName.substring(index + 1);
                                final String uri = OdfDocumentNamespace.getUri(prefix);
                                if(uri!=null) {
                                    attributes.setValue(uri, localName, qName, (String)jsonEntry.getValue());
                                }
                            }
                        }
                    }
                }
                if(formatCode!=null) {
                    if(formatCode==JSONObject.NULL) {
                        attributes.remove("style:date-style-name");
                    }
                    else if(formatCode instanceof String&&!((String)formatCode).isEmpty()) {
                        attributes.setValue(Namespaces.STYLE, "data-style-name", "style:data-style-name",
                            operationDocument.getDocument().getStyleManager().applyDataStyle((String)formatCode, additionalStyleProperties, -1, false, true, isContentAutoStyle()));
                    }
                }
            }
        }
        super.applyAttrsFromJSON(operationDocument, attrs);
    }

    @Override
    public void createAttrs(OdfOperationDoc operationDocument, OpAttrs attrs) {
        super.createAttrs(operationDocument, attrs);

        final Map<String, AttributeImpl> attributes = ((TextField)getObject()).getAttributes().getUnmodifiableMap();
        if(attributes.size()>0) {
            final HashMap<String, String> map = new HashMap<String, String>(attributes.size());
            final Iterator<AttributeImpl> attrIter = attributes.values().iterator();
            while(attrIter.hasNext()) {
                final AttributeImpl attr = attrIter.next();
                if(attr.getQName().equals("style:data-style-name")) {
                    final StyleManager styleManager = operationDocument.getDocument().getStyleManager();
                    final StyleBase dataStyle = styleManager.getStyle(attr.getValue(), StyleFamily.DATA_STYLE, isContentAutoStyle());
                    if(dataStyle instanceof NumberStyleBase) {
                        final String formatCode = ((NumberStyleBase)dataStyle).getFormat(styleManager, map, isContentAutoStyle());
                        if(formatCode!=null&&!formatCode.isEmpty()) {
                            map.put("dateFormat", formatCode);
                        }
                    }
                }
                else if(attr.getQName().equals("style:num-format")) {
                    map.put("pageNumFormat", attr.getValue());
                }
                else {
                    map.put(attr.getQName(), attr.getValue());
                }
            }
            attrs.getMap(OCKey.CHARACTER.value(), true).put(OCKey.FIELD.value(), map);
        }
    }
}
