/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package org.docx4j.dml.wordprocessingCanvas2010;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.docx4j.IndexedNodeList;
import org.docx4j.dml.CTBackgroundFormatting;
import org.docx4j.dml.CTOfficeArtExtensionList;
import org.docx4j.dml.CTWholeE2OFormatting;
import org.docx4j.dml.picture.Pic;
import org.docx4j.dml.wordprocessingGroup2010.CTGraphicFrame;
import org.docx4j.dml.wordprocessingGroup2010.CTWordprocessingGroup;
import org.docx4j.dml.wordprocessingShape2010.CTWordprocessingShape;
import org.docx4j.w14.CTWordContentPart;
import org.docx4j.wml.ContentAccessor;


/**
 * <p>Java class for CT_WordprocessingCanvas complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CT_WordprocessingCanvas">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="bg" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_BackgroundFormatting" minOccurs="0"/>
 *         &lt;element name="whole" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_WholeE2oFormatting" minOccurs="0"/>
 *         &lt;choice maxOccurs="unbounded" minOccurs="0">
 *           &lt;element ref="{http://schemas.microsoft.com/office/word/2010/wordprocessingShape}wsp"/>
 *           &lt;element ref="{http://schemas.openxmlformats.org/drawingml/2006/picture}pic"/>
 *           &lt;element ref="{http://schemas.microsoft.com/office/word/2010/wordml}contentPart"/>
 *           &lt;element ref="{http://schemas.microsoft.com/office/word/2010/wordprocessingGroup}wgp"/>
 *           &lt;element name="graphicFrame" type="{http://schemas.microsoft.com/office/word/2010/wordprocessingGroup}CT_GraphicFrame"/>
 *         &lt;/choice>
 *         &lt;element name="extLst" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_OfficeArtExtensionList" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlRootElement(name="wpc")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_WordprocessingCanvas", propOrder = {
    "bg",
    "whole",
    "wspOrPicOrContentPart",
    "extLst"
})
public class CTWordprocessingCanvas implements ContentAccessor {

    protected CTBackgroundFormatting bg;
    protected CTWholeE2OFormatting whole;
    @XmlElements({
        @XmlElement(name = "wsp", namespace = "http://schemas.microsoft.com/office/word/2010/wordprocessingShape", type = CTWordprocessingShape.class),
        @XmlElement(name = "pic", namespace = "http://schemas.openxmlformats.org/drawingml/2006/picture", type = Pic.class),
        @XmlElement(name = "contentPart", namespace = "http://schemas.microsoft.com/office/word/2010/wordml", type = CTWordContentPart.class),
        @XmlElement(name = "wgp", namespace = "http://schemas.microsoft.com/office/word/2010/wordprocessingGroup", type = CTWordprocessingGroup.class),
        @XmlElement(name = "graphicFrame", type = CTGraphicFrame.class)
    })
    protected IndexedNodeList<Object> wspOrPicOrContentPart;
    protected CTOfficeArtExtensionList extLst;

    /**
     * Gets the value of the bg property.
     *
     * @return
     *     possible object is
     *     {@link CTBackgroundFormatting }
     *
     */
    public CTBackgroundFormatting getBg() {
        return bg;
    }

    /**
     * Sets the value of the bg property.
     *
     * @param value
     *     allowed object is
     *     {@link CTBackgroundFormatting }
     *
     */
    public void setBg(CTBackgroundFormatting value) {
        this.bg = value;
    }

    /**
     * Gets the value of the whole property.
     *
     * @return
     *     possible object is
     *     {@link CTWholeE2OFormatting }
     *
     */
    public CTWholeE2OFormatting getWhole() {
        return whole;
    }

    /**
     * Sets the value of the whole property.
     *
     * @param value
     *     allowed object is
     *     {@link CTWholeE2OFormatting }
     *
     */
    public void setWhole(CTWholeE2OFormatting value) {
        this.whole = value;
    }

    /**
     * Gets the value of the wspOrPicOrContentPart property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the wspOrPicOrContentPart property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWspOrPicOrContentPart().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CTWordprocessingShape }
     * {@link Pic }
     * {@link CTWordContentPart }
     * {@link CTWordprocessingGroup }
     * {@link CTGraphicFrame }
     *
     *
     */
    public IndexedNodeList<Object> getContent() {
        if (wspOrPicOrContentPart == null) {
            wspOrPicOrContentPart = new IndexedNodeList<Object>();
        }
        return this.wspOrPicOrContentPart;
    }

    /**
     * Gets the value of the extLst property.
     *
     * @return
     *     possible object is
     *     {@link CTOfficeArtExtensionList }
     *
     */
    public CTOfficeArtExtensionList getExtLst() {
        return extLst;
    }

    /**
     * Sets the value of the extLst property.
     *
     * @param value
     *     allowed object is
     *     {@link CTOfficeArtExtensionList }
     *
     */
    public void setExtLst(CTOfficeArtExtensionList value) {
        this.extLst = value;
    }

}
