/*
 *  Copyright 2007-2008, Plutext Pty Ltd.
 *
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */


package org.docx4j.dml.spreadsheetdrawing;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlType;
import org.docx4j.dml.CTPoint2D;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.jaxb.Context;
import org.docx4j.mce.AlternateContent;


/**
 * <p>Java class for CT_AbsoluteAnchor complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CT_AbsoluteAnchor">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="pos" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_Point2D"/>
 *         &lt;element name="ext" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_PositiveSize2D"/>
 *         &lt;group ref="{http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing}EG_ObjectChoices"/>
 *         &lt;element name="clientData" type="{http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing}CT_AnchorClientData"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_AbsoluteAnchor", propOrder = {
    "pos",
    "ext",
    "sp",
    "grpSp",
    "graphicFrame",
    "cxnSp",
    "pic",
    "alternateContent",
    "clientData"
})
public class CTAbsoluteAnchor implements ICellAnchor {

    @XmlElement(required = true)
    protected CTPoint2D pos;
    @XmlElement(required = true)
    protected CTPositiveSize2D ext;
    @XmlElement(required = true)
    protected CTAnchorClientData clientData;

    protected CTShape sp;
    protected CTGroupShape grpSp;
    protected CTGraphicalObjectFrame graphicFrame;
    protected CTConnector cxnSp;
    protected CTPicture pic;

    @XmlElementRef(name = "alternateContent", namespace = "http://schemas.openxmlformats.org/markup-compatibility/2006", type = AlternateContent.class)
    protected AlternateContent alternateContent;

    /**
     * Gets the value of the pos property.
     *
     * @return
     *     possible object is
     *     {@link CTPoint2D }
     *
     */
    public CTPoint2D getPos(boolean forceCreate) {
        if(pos==null&&forceCreate) {
            pos = Context.getDmlObjectFactory().createCTPoint2D();
        }
        return pos;
    }

    /**
     * Sets the value of the pos property.
     *
     * @param value
     *     allowed object is
     *     {@link CTPoint2D }
     *
     */
    public void setPos(CTPoint2D value) {
        this.pos = value;
    }

    /**
     * Gets the value of the ext property.
     *
     * @return
     *     possible object is
     *     {@link CTPositiveSize2D }
     *
     */
    public CTPositiveSize2D getExt(boolean forceCreate) {
        if(ext==null&&forceCreate) {
            ext = Context.getDmlObjectFactory().createCTPositiveSize2D();
        }
        return ext;
    }

    /**
     * Sets the value of the ext property.
     *
     * @param value
     *     allowed object is
     *     {@link CTPositiveSize2D }
     *
     */
    public void setExt(CTPositiveSize2D value) {
        this.ext = value;
    }

    /**
     * Gets the value of the sp property.
     *
     * @return
     *     possible object is
     *     {@link CTShape }
     *
     */
    @Override
    public CTShape getSp() {
        if (alternateContent != null) {
            for (Object alt : alternateContent.getFallback().getAny()) {
                if (alt instanceof CTShape) {
                    return (CTShape) alt;
                }
            }
        }
        return sp;
    }

    /**
     * Sets the value of the sp property.
     *
     * @param value
     *     allowed object is
     *     {@link CTShape }
     *
     */
    @Override
    public void setSp(CTShape sp) {
        alternateContent = null;
        this.sp = sp;
    }

    /**
     * Gets the value of the grpSp property.
     *
     * @return
     *     possible object is
     *     {@link CTGroupShape }
     *
     */
    @Override
    public CTGroupShape getGrpSp() {
        if (alternateContent != null) {
            for (Object alt : alternateContent.getFallback().getAny()) {
                if (alt instanceof CTGroupShape) {
                    return (CTGroupShape) alt;
                }
            }
        }
        return grpSp;
    }

    /**
     * Sets the value of the grpSp property.
     *
     * @param value
     *     allowed object is
     *     {@link CTGroupShape }
     *
     */
    @Override
    public void setGrpSp(CTGroupShape value) {
        alternateContent = null;
        this.grpSp = value;
    }

    /**
     * Gets the value of the graphicFrame property.
     *
     * @return
     *     possible object is
     *     {@link CTGraphicalObjectFrame }
     *
     */
    @Override
    public CTGraphicalObjectFrame getGraphicFrame() {
        if (alternateContent != null) {
            for (Object alt : alternateContent.getFallback().getAny()) {
                if (alt instanceof CTGraphicalObjectFrame) {
                    return (CTGraphicalObjectFrame) alt;
                }
            }
        }
        return graphicFrame;
    }

    /**
     * Sets the value of the graphicFrame property.
     *
     * @param value
     *     allowed object is
     *     {@link CTGraphicalObjectFrame }
     *
     */
    @Override
    public void setGraphicFrame(CTGraphicalObjectFrame value) {
        alternateContent = null;
        this.graphicFrame = value;
    }

    /**
     * Gets the value of the cxnSp property.
     *
     * @return
     *     possible object is
     *     {@link CTConnector }
     *
     */
    @Override
    public CTConnector getCxnSp() {
        if (alternateContent != null) {
            for (Object alt : alternateContent.getFallback().getAny()) {
                if (alt instanceof CTConnector) {
                    return (CTConnector) alt;
                }
            }
        }
        return cxnSp;
    }

    /**
     * Sets the value of the cxnSp property.
     *
     * @param value
     *     allowed object is
     *     {@link CTConnector }
     *
     */
    @Override
    public void setCxnSp(CTConnector value) {
        alternateContent = null;
        this.cxnSp = value;
    }

    /**
     * Gets the value of the pic property.
     *
     * @return
     *     possible object is
     *     {@link CTPicture }
     *
     */
    @Override
    public CTPicture getPic() {
        if (alternateContent != null) {
            for (Object alt : alternateContent.getFallback().getAny()) {
                if (alt instanceof CTPicture) {
                    return (CTPicture) alt;
                }
            }
        }
        return pic;
    }

    /**
     * Sets the value of the pic property.
     *
     * @param value
     *     allowed object is
     *     {@link CTPicture }
     *
     */
    @Override
    public void setPic(CTPicture value) {
        alternateContent = null;
        this.pic = value;
    }

    /**
     * Gets the value of the clientData property.
     *
     * @return
     *     possible object is
     *     {@link CTAnchorClientData }
     *
     */
    @Override
    public CTAnchorClientData getClientData() {
        return clientData;
    }

    /**
     * Sets the value of the clientData property.
     *
     * @param value
     *     allowed object is
     *     {@link CTAnchorClientData }
     *
     */
    @Override
    public void setClientData(CTAnchorClientData value) {
        this.clientData = value;
    }

    /* check if the txBody is valid */
    public void beforeMarshal(Marshaller marshaller) {
        if(clientData==null) {
            clientData = new CTAnchorClientData();
        }
    }

    @Override
    public AlternateContent getAlternateContent() {
        return alternateContent;
    }

    @Override
    public void setAlternateContent(AlternateContent alternateContent) {
        this.alternateContent = alternateContent;
    }

}
