/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.rest;

import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.encoding.Base64;
import com.openexchange.tools.session.ServerSession;


/**
 * {@link GetDocumentAction}
 *
 * @author <a href="mailto:malte.timmermann@open-xchange.com">Malte Timmermann</a>
 */
/*
 * MH/KA compilefix for buildsystem
 *
@Action(method = RequestMethod.GET, name = "getdocument", description = "Get the whole document in the original format, or converted to any supported document format.", parameters = {
    @Parameter(name = "session", description = "A session ID previously obtained from the login module."),
    @Parameter(name = "id", description = "Object ID of the requested infoitem."),
    @Parameter(name = "folder_id", description = "Folder ID of the requested infoitem."),
    @Parameter(name = "uid", description = "The unique id of the client application."),
    @Parameter(name = "version", optional=true, description = "If present, the infoitem data describes the given version. Otherwise the current version is returned."),
    @Parameter(name = "filter_format", optional=true, description = "If this value is set to 'pdf', the whole document is as converted PDF file, in all other cases, the content of the document's substream, described by the parameter 'fragment, is returned as unmodified file."),
    @Parameter(name = "fragment", optional=true, description = "If this value is set and the filter_format is not set or not set to 'pdf', this parameter describes the substream name of the document internal file to be returned."),
    @Parameter(name = "filename", optional=true, description = "If present, this parameter contains the name of the infostore item to be used as initial part of the filename for the returned file, other the filename is set to 'file'."),
}, responseDescription = "Response with timestamp: The document in it's original format or converted to the requested format.")
 *
 */

@DispatcherNotes(defaultFormat = "file", allowPublicSession = true)
public class GetDocumentAction extends DocumentRESTAction {

    // ---------------------------------------------------------------
    @SuppressWarnings("deprecation")
    private static final Log LOG = com.openexchange.log.Log.loggerFor(GetDocumentAction.class);

    private static final String m_base64Str = ";base64,";
    private static final String m_dataStr = "data:";
    private static final String m_dataUrlKey = "dataurl";
    private static final String m_dataUrlValue = m_dataUrlKey;
    private static final String m_defaultDocumentName = "document";
    private static final String m_defaultMimeType = "application/octet-stream";
    private static final String m_documentFormatKey = "documentformat";
    private static final String m_documentFormatParam = m_documentFormatKey;
    private static final String m_fileNameKey = "filename";
    private static final String m_fileNameParam = m_fileNameKey;
    private static final String m_mimeTypeKey = "mimetype";
    private static final String m_resourceNameKey = "resourcename";
    private static final String m_returnTypeKey = "returntype";
    private static final String m_SourceKey = "source";
    private static final String m_FolderKey = "folder";
    private static final String m_IdKey = "id";
    private static final String m_ModuleKey = "module";
    private static final String m_AttachmentKey = "attachment";

    /**
     * Initializes a new {@link GetDocumentAction}.
     *
     * @param services
     */
    public GetDocumentAction(ServiceLookup servicesDEPRECATED) {
        super(null);
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.ajax.requesthandler.AJAXActionService#perform(com.openexchange.ajax.requesthandler.AJAXRequestData,
     * com.openexchange.tools.session.ServerSession)
     */
    @Override
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) {
        final JSONObject requestData = new JSONObject();
        JSONObject resultData = null;
        AJAXRequestResult ajaxResult = null;

        try {
            requestData.put(m_documentFormatKey, request.getParameter(m_documentFormatKey));
            requestData.put(m_fileNameKey, request.getParameter(m_fileNameKey));
            requestData.put(m_returnTypeKey, m_dataUrlValue);
            requestData.put(m_mimeTypeKey, request.getParameter(m_mimeTypeKey));
            requestData.put(m_SourceKey, request.getParameter(m_SourceKey));
            requestData.put(m_FolderKey, request.getParameter(ParameterDefinitions.PARAM_FOLDER_ID));
            requestData.put(m_IdKey, request.getParameter(ParameterDefinitions.PARAM_FILE_ID));
            requestData.put(m_ModuleKey, request.getParameter(m_ModuleKey     ));
            requestData.put(m_AttachmentKey, request.getParameter(m_AttachmentKey ));

            resultData = sendConnectionMessageSynchronously(request, session, "getDocument", "document", requestData);
        } catch (JSONException e) {
            LOG.warn("GetDocumentAction caught JSONException trying to build request for sendConnectionMessageSynchronously", e);
        }

        if ((null != resultData) && (resultData.has(m_dataUrlKey))) {
            try {
                String dataURL = resultData.getString(m_dataUrlKey);
                final int pos1 = dataURL.indexOf(m_dataStr);
                final int pos2 = dataURL.indexOf(m_base64Str);

                if ((pos1 > - 1) && (pos2 > -1) && ((pos1 + m_dataStr.length()) < pos2)) {
                    final byte[] dataBuffer = Base64.decode(dataURL.substring(pos2 + m_base64Str.length()));

                    if (null != dataBuffer) {
                        final String mimeType = resultData.has(m_mimeTypeKey) ? resultData.getString(m_mimeTypeKey) : m_defaultMimeType;
                        final String resourceName = resultData.has(m_resourceNameKey) ? resultData.getString(m_resourceNameKey) : m_defaultDocumentName;
                        final ByteArrayFileHolder fileHolder = new ByteArrayFileHolder(dataBuffer);

                        fileHolder.close();
                        fileHolder.setName(resourceName);
                        fileHolder.setContentType(mimeType);
                        ajaxResult = new AJAXRequestResult(fileHolder, "file");
                    }
                }
            } catch (JSONException e) {
                LOG.warn("GetDocumentAction caught JSONException trying to create response", e);
            }
        }

        if (null == ajaxResult) {
            request.setFormat("json");
            ajaxResult = getAjaxRequestResult(null);
        }

        return ajaxResult;
    }
}
