/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.pptx.components;

import org.docx4j.Child;
import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.wml.ContentAccessor;
import org.json.JSONException;
import org.json.JSONObject;
import org.pptx4j.pml.CTGraphicalObjectFrame;
import org.pptx4j.pml.CxnSp;
import org.pptx4j.pml.GroupShape;
import org.pptx4j.pml.Pic;
import org.pptx4j.pml.Shape;
import com.openexchange.office.filter.ooxml.components.Component;
import com.openexchange.office.filter.ooxml.components.ComponentContext;
import com.openexchange.office.filter.ooxml.components.IShapeType;
import com.openexchange.office.filter.ooxml.components.ShapeType;
import com.openexchange.office.filter.ooxml.pptx.tools.PMLShapeHelper;

public class ShapeGroupComponent extends PptxComponent implements IShapeComponent, IShapeType {

	final GroupShape groupShape;

	public ShapeGroupComponent(ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);

        groupShape = (GroupShape)getObject();
	}

    @Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        final IndexedNode<Object> groupShapeNode = getNode();
        final IndexedNodeList<Object> nodeList = (IndexedNodeList<Object>)((ContentAccessor)groupShapeNode.getData()).getContent();
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;
        IndexedNode<Object> childNode = previousChildContext!=null ? nodeList.getNextNode(previousChildContext.getNode()) : nodeList.getFirstNode();

        Component nextComponent = null;
        for(; nextComponent==null&&childNode!=null; childNode = nodeList.getNextNode(childNode)) {
            final Object o = getContentModel(childNode, groupShapeNode.getData());
            if(o instanceof GroupShape) {
            	nextComponent = new ShapeGroupComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof Shape) {
            	nextComponent = new ShapeComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof CTGraphicalObjectFrame) {
            	nextComponent = new ShapeGraphicComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof CxnSp) {
            	nextComponent = new ShapeConnectorComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof Pic) {
            	nextComponent = new ShapePicComponent(this, childNode, nextComponentNumber);
            }
/*
            else if(o instanceof CTRel) {
            	nextComponent = new ShapeRelComponent(this, childNode, nextComponentNumber);
            }
*/
        }
        return nextComponent;
    }

    @Override
    public Component insertChildComponent(ComponentContext parentContext, IndexedNode<Object> contextNode, int number, Component child, Type type) {

    	IndexedNodeList<Object> indexedNodeList = (IndexedNodeList<Object>)((ContentAccessor)contextNode.getData()).getContent();
        IndexedNode<Object> referenceNode = child!=null ? child.getNode() : null;

        groupShape.setModified();

        switch(type) {
        	case AC_SHAPE: {
	            final Child newChild = PMLShapeHelper.createShape();
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapeComponent(parentContext, newChildNode, number);
        	}
        	case AC_GROUP: {
	            final Child newChild = PMLShapeHelper.createGroupShape();
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapeGroupComponent(parentContext, newChildNode, number);
        	}
        	case AC_CONNECTOR: {
	            final Child newChild = PMLShapeHelper.createConnectorShape();
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapeConnectorComponent(parentContext, newChildNode, number);
        	}
        	case AC_IMAGE: {
	            final Child newChild = PMLShapeHelper.createImage();
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapePicComponent(parentContext, newChildNode, number);
        	}
        	default : {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void applyAttrsFromJSON(JSONObject attrs)
    	throws JSONException, InvalidFormatException, PartUnrecognisedException {

    	PMLShapeHelper.applyAttrsFromJSON(operationDocument, attrs, groupShape);
    	com.openexchange.office.filter.ooxml.drawingml.GroupShape.applyAttrsFromJSON(operationDocument, attrs, groupShape, !(getParentComponent() instanceof ShapeGroupComponent));
    }

    @Override
    public JSONObject createJSONAttrs(JSONObject attrs)
    	throws JSONException {

    	PMLShapeHelper.createJSONAttrs(attrs, groupShape);
        com.openexchange.office.filter.ooxml.drawingml.GroupShape.createJSONAttrs(operationDocument, attrs, groupShape, !(getParentComponent() instanceof ShapeGroupComponent));
    	return attrs;
    }

	@Override
	public Long getId() {
		final CTNonVisualDrawingProps nvdProps = groupShape.getNonVisualDrawingProperties(false);
		return nvdProps!=null ? nvdProps.getId() : null;
	}

	@Override
	public ShapeType getType() {
		return ShapeType.GROUP;
	}

	@Override
	public boolean isPresentationObject() {
		return false;
	}
}
