/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.docx.components;

import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.docx4j.IndexedNode;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTFFCheckBox;
import org.docx4j.wml.CTFFDDList;
import org.docx4j.wml.CTFFData;
import org.docx4j.wml.CTFFTextInput;
import org.docx4j.wml.FldChar;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.api.FilterException;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.ooxml.components.ComponentContext;

abstract class FldChar_Base extends TextRun_Base {

    final FldChar fldChar;

    public FldChar_Base(ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);

        fldChar = (FldChar)getObject();
    }

    @Override
	public void applyAttrsFromJSON(JSONObject attrs)
			throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

		super.applyAttrsFromJSON(attrs);
		removeInvalidParents();
	}

    public void removeInvalidParents() {
        if(getHyperlink(false)!=null) {
            splitStart(getComponentNumber(), SplitMode.ATTRIBUTE);
            splitEnd(getComponentNumber(), SplitMode.ATTRIBUTE);
            if(getHyperlink(false)!=null) {
                removeHyperlink();
            }
        }
    }

    @Override
	public JSONObject createJSONAttrs(JSONObject attrs)
			throws JSONException, ParseException, FilterException {

		super.createJSONAttrs(attrs);

		final CTFFData ffData = fldChar.getFfData();
		if(ffData!=null) {
		    JSONObject characterAttrs = attrs.optJSONObject(OCKey.CHARACTER.value());
		    if(characterAttrs==null) {
		        characterAttrs = new JSONObject(1);
		        attrs.put(OCKey.CHARACTER.value(), characterAttrs);
		    }
		    final JSONObject field = new JSONObject();
		    final List<JAXBElement<?>> ffContent = ffData.getNameOrEnabledOrCalcOnExit();
		    final Iterator<JAXBElement<?>> ffIter = ffContent.iterator();
		    boolean enabled = true;
		    while(ffIter.hasNext()) {
		        final JAXBElement<?> ffEntry = ffIter.next();
		        final Object ffEntryValue = ffEntry.getValue();
		        if(ffEntryValue instanceof CTFFCheckBox) {
		            field.put(OCKey.FORM_FIELD_TYPE.value(), "checkBox");
		            final BooleanDefaultTrue defaultV = ((CTFFCheckBox)ffEntryValue).getDefault();
		            final BooleanDefaultTrue checkedV = ((CTFFCheckBox)ffEntryValue).getChecked();
		            boolean checked = true;
		            if(checkedV!=null) {
		                checked = checkedV.isVal();
		            }
		            else if(defaultV!=null) {
		                checked = defaultV.isVal();
		            }
                    field.put(OCKey.CHECKED.value(), checked);
		        }
		        else if(ffEntryValue instanceof CTFFTextInput) {
		            field.put(OCKey.FORM_FIELD_TYPE.value(), "textInput");
		        }
		        else if(ffEntryValue instanceof CTFFDDList) {
		            field.put(OCKey.FORM_FIELD_TYPE.value(), "dropDownList");
		        }
		        else if(ffEntryValue instanceof BooleanDefaultTrue) {
		            if(ffEntry.getName().getLocalPart().equals("enabled")) {
		                enabled = ((BooleanDefaultTrue)ffEntryValue).isVal();
		            }
		        }
		    }
		    field.put(OCKey.ENABLED.value(), enabled);
		    characterAttrs.put(OCKey.FIELD.value(), field);
		}
		return attrs;
	}
}
