/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.docx.components;

import java.text.ParseException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.docx4j.Child;
import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.R;
import org.docx4j.wml.STFldCharType;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.api.FilterException;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.ooxml.components.ComponentContext;
import com.openexchange.office.filter.ooxml.docx.tools.TextRunState;
import com.openexchange.office.filter.ooxml.docx.tools.TextUtils;

public class FldCharSeparate extends FldChar_Base {

    private final FldCharBegin fldCharBegin;

    public FldCharSeparate(ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber, FldCharBegin fldCharBegin) {
        super(parentContext, _node, _componentNumber);

        this.fldCharBegin = fldCharBegin;
    }

    public FldCharBegin getFldCharBegin() {
        return fldCharBegin;
    }

    @Override
    public void applyAttrsFromJSON(JSONObject attrs)
            throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

        final Object characterAttrs = attrs.opt(OCKey.CHARACTER.value());
        if(characterAttrs instanceof JSONObject) {
            final Object autoDateField = ((JSONObject)characterAttrs).opt(OCKey.AUTO_DATE_FIELD.value());
            if(autoDateField instanceof Boolean) {
                applyAutoDateField((Boolean)autoDateField);
            }
            else {
                applyAutoDateField(true);
            }
        }
        final Object changes = attrs.opt(OCKey.CHANGES.value());
        if(changes!=null&&fldCharBegin!=null) {
            final R start = fldCharBegin.getTextRun();
            final R end = getTextRun();
            // now find each R between start and end and apply changetracking
            Object current = start;
            while(current!=null) {
                current = getNextObject(current);
                if(current instanceof IndexedNode) {
                    current = ((IndexedNode<?>)current).getData();
                }
                if(current==end) {
                    break;
                }
                if(current instanceof R) {
                    TextUtils.applyTextRunAttributes(getOperationDocument(), attrs, new TextRunState((R)current));
                }
            }
        }
        super.applyAttrsFromJSON(attrs);
    }

    private static Object getNextObject(Object currentObject) {
        IndexedNode<Object> next = getNextSibling(currentObject);
        if(next!=null) {
            IndexedNode<Object> child = null;
            do {
                child = getFirstChild(next);
                if(child!=null) {
                    next = child;
                }
            }
            while(child!=null);

            return next;
        }
        return getParent(currentObject);
    }

    private static IndexedNode<Object> getNextSibling(Object currentObject) {
        IndexedNode<?> currentNode = null;
        if(currentObject instanceof IndexedNode) {
            currentNode = (IndexedNode<?>)currentObject;
            currentObject = currentNode.getData();
        }
        if(!(currentObject instanceof Child)) {
            return null;
        }
        final Object parentObject = ((Child)currentObject).getParent();
        if(!(parentObject instanceof ContentAccessor)) {
            return null;
        }
        final Object content = ((ContentAccessor)parentObject).getContent();
        if(!(content instanceof IndexedNodeList)) {
            return null;
        }
        if(currentNode==null) {
            currentNode = ((IndexedNodeList<?>)content).getNode(((IndexedNodeList<?>)content).indexOf(currentObject));
        }
        return ((IndexedNodeList)content).getNextNode(currentNode);
    }

    private static Object getParent(Object currentObject) {
        if(currentObject instanceof IndexedNode) {
            currentObject = ((IndexedNode<?>)currentObject).getData();
        }
        if(!(currentObject instanceof Child)) {
            return null;
        }
        final Object parentObject = ((Child)currentObject).getParent();
        if(!(parentObject instanceof ContentAccessor)) {
            return null;
        }
        return parentObject;
    }

    private static IndexedNode<Object> getFirstChild(Object currentObject) {
        IndexedNode<?> currentNode = null;
        if(currentObject instanceof IndexedNode) {
            currentNode = (IndexedNode<?>)currentObject;
            currentObject = currentNode.getData();
        }
        if(!(currentObject instanceof ContentAccessor)) {
            return null;
        }
        final Object content = ((ContentAccessor)currentObject).getContent();
        if(!(content instanceof IndexedNodeList)) {
            return null;
        }
        return ((IndexedNodeList)content).getFirstNode();
    }

    @Override
    public JSONObject createJSONAttrs(JSONObject attrs)
            throws JSONException, ParseException, FilterException {

        if(getComponentNumber()-1>=0) {
            final Object prev = getParentComponent().getChildComponent(getComponentNumber()-1).getObject();
            if(prev instanceof FldChar) {
                JSONObject characterAttrs = attrs.optJSONObject(OCKey.CHARACTER.value());
                if(characterAttrs==null) {
                    characterAttrs = new JSONObject(1);
                    attrs.put(OCKey.CHARACTER.value(), characterAttrs);
                }
                characterAttrs.put(OCKey.AUTO_DATE_FIELD.value(), !((FldChar)prev).isFldLock());
            }
        }
        super.createJSONAttrs(attrs);
        return attrs;
    }

    @Override
    public void delete(int count)
        throws InvalidFormatException {
        if(fldCharBegin!=null) {
            final List<IndexedNode<Object>> instructionNodes = fldCharBegin.getInstructionNodes();
            if(instructionNodes!=null) {
                for(int i=instructionNodes.size()-1; i>=0; i--) {
                    final IndexedNode<Object> instrNode = instructionNodes.get(i);
                    final Child instrText = (Child)instrNode.getData();
                    final Object instrTextParent = instrText.getParent();
                    if(instrTextParent instanceof R&&((R)instrTextParent).getContent().size()==1) { // removing R completely
                        ((ContentAccessor)(((R)instrTextParent).getParent())).getContent().remove(instrTextParent);
                    } else {
                        ((ContentAccessor)(instrText.getParent())).getContent().remove(instrText);
                    }
                }
            }
        }
        super.delete(count);
    }

    private void applyAutoDateField(Boolean val) {
        if(getComponentNumber()-1>=0) {
            final Object prev = getParentComponent().getChildComponent(getComponentNumber()-1).getObject();
            if(prev instanceof FldChar) {
                if(((FldChar)prev).getFldCharType() == STFldCharType.BEGIN) {
                    ((FldChar)prev).setFldLock(val!=null?!val.booleanValue():false);
                }
            }
        }
    }
}
