/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ods.dom;

import org.apache.xml.serializer.SerializationHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.SaxContextHandler;

public class NamedExpression {

	private String 	name;
	private String 	baseCellAddress;
	private String	expression;
	private String	cellRangeAddress;
	private String	rangeUsableAs;

	public NamedExpression(String name) {
		this.name = name;
	}

	public NamedExpression(Attributes attributes) {
		name = attributes.getValue("table:name");
		baseCellAddress = attributes.getValue("table:base-cell-address");
		expression = attributes.getValue("table:expression");
		cellRangeAddress = attributes.getValue("table:cell-range-address");
		rangeUsableAs = attributes.getValue("table:range-usable-as");
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getBaseCellAddress() {
		return baseCellAddress;
	}

	public void setBaseCellAddress(String baseCellAddress) {
		this.baseCellAddress = baseCellAddress;
	}

	public String getCellRangeAddress() {
		return cellRangeAddress;
	}

	public void setCellRangeAddress(String cellRangeAddress) {
		this.cellRangeAddress = cellRangeAddress;
		expression = null;
	}

	public String getExpression() {
		return expression;
	}

	public void setExpression(String expression) {
		this.expression = expression;
		cellRangeAddress = null;
		rangeUsableAs = null;
	}

	public void writeObject(SerializationHandler output)
		throws SAXException {

		if(expression!=null) {
			SaxContextHandler.startElement(output, Namespaces.TABLE, "named-expression", "table:named-expression");
		}
		else {
			SaxContextHandler.startElement(output, Namespaces.TABLE, "named-range", "table:named-range");
		}
    	SaxContextHandler.addAttribute(output, Namespaces.TABLE, "name", "table:name", name);
    	SaxContextHandler.addAttribute(output, Namespaces.TABLE, "base-cell-address", "table:base-cell-address", baseCellAddress==null?"":baseCellAddress);
    	if(expression!=null) {
        	SaxContextHandler.addAttribute(output, Namespaces.TABLE, "expression", "table:expression", expression);
    	}
    	else {
        	SaxContextHandler.addAttribute(output, Namespaces.TABLE, "cell-range-address", "table:cell-range-address", cellRangeAddress==null?"":cellRangeAddress);
        	if(rangeUsableAs!=null) {
        		SaxContextHandler.addAttribute(output, Namespaces.TABLE, "range-usable-as", "table:range-usable-as", rangeUsableAs);
        	}
    	}
		if(expression!=null) {
			SaxContextHandler.endElement(output, Namespaces.TABLE, "named-expression", "table:named-expression");
		}
		else {
			SaxContextHandler.endElement(output, Namespaces.TABLE, "named-range", "table:named-range");
		}
	}
}
