/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.draw;

import org.xml.sax.Attributes;
import com.google.common.collect.ImmutableMap;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.ElementToBase64Handler;
import com.openexchange.office.filter.odf.SaxContextHandler;
import com.openexchange.office.filter.odf.draw.EnhancedGeometry.MT;

public class EnhancedGeometryHandler extends ElementToBase64Handler {

    final CustomShape customShape;

    public EnhancedGeometryHandler(SaxContextHandler parentContext, CustomShape customShape, Attributes attributes, String uri, String localName, String qName) {
    	super(parentContext, attributes, uri, localName, qName);

    	this.customShape = customShape;

    	final EnhancedGeometry enhancedGeometry = customShape.getEnhancedGeometry(true);
    	final String customShapeType= attributes.getValue("draw:type");
    	if(customShapeType!=null) {
    	    String presetShape;
            if(customShapeType.startsWith("ooxml-")&&customShapeType.length() > 6) {
                presetShape = customShapeType.substring(6);
            }
            else {
                presetShape = EnhancedGeometry.OOShapeTypes.get(customShapeType);
                if(presetShape==null&&"mso-spt100".equals(customShapeType)) {
                    final String enhancedPath = attributes.getValue("draw:enhanced-path");
                    if(enhancedPath!=null) {
                        if(enhancedPath.equals("V 0 0 21600 21600 ?f5 ?f7 ?f1 ?f3 L 10800 10800 Z N")) {
                            presetShape = "pie";
                        }
                        else if(enhancedPath.startsWith("M ?f0 0 L 21600 10800 ?f0 21800 ?f0 ?f2")) {
                            presetShape = "stripedRightArrow";
                        }
                    }
                }
            }
            if(presetShape==null||presetShape.equals("none-primitive")) {
                final String enhancedPath = attributes.getValue("draw:enhanced-path");
                if(!enhancedPath.contains("$")&&!enhancedPath.contains("?")) {
                    enhancedGeometry.setPathList(SVGPathParser.getPathList(enhancedPath, new ViewBox(attributes.getValue("svg:viewBox")), false));
                }
            }
        	enhancedGeometry.setPresetShape(presetShape);
            final String modifiers = attributes.getValue("draw:modifiers");
            if(modifiers!=null) {
                final String[] tokens = modifiers.split("\\s+");
            	if(customShapeType.startsWith("ooxml-")) {
                    int i = 1;
                    final String adjNames[] = OOXMLAdjustmentNames.get(presetShape);
            	    for(String token:tokens) {
            	        Double number = 0.0;
            	        try {
            	            number = Double.parseDouble(token);
            	        }
            	        catch(NumberFormatException e) {
            	            // ohoh
            	        }
            	        if(adjNames!=null&&adjNames.length>=i) {
                            enhancedGeometry.getModifiers(true).put(adjNames[i-1], number);
            	        }
            	        else {
            	            enhancedGeometry.getModifiers(true).put("adj" + Integer.valueOf(i++).toString(), number);
            	        }
            	    }
            	}
            	else {
                    final MT modifierTransformation = EnhancedGeometry.OOShapeToOOXModifierTransformation.get("mso-spt100".equals(customShapeType) ? presetShape : customShapeType);
            	    if(modifierTransformation!=null) {
                        enhancedGeometry.setModifierTransformer(modifierTransformation);
            	        modifierTransformation.transform(tokens, enhancedGeometry.getModifiers(true));
            	    }
            	}
            }
            customShape.getTransformer().setFlipH(AttributesImpl.getBoolean(attributes.getValue("draw:mirror-horizontal"), null));
            customShape.getTransformer().setFlipV(AttributesImpl.getBoolean(attributes.getValue("draw:mirror-vertical"), null));
    	}
    	enhancedGeometry.setModified(false);
	}

	@Override
	final protected void setBase64ElementData(String data) {
	    customShape.getEnhancedGeometry(true).setShapeData(data);
	}

	static final protected ImmutableMap<String, String[]> OOXMLAdjustmentNames = ImmutableMap.<String, String[]> builder()
        .put("bevel", new String[] {"adj"})
        .put("bracePair", new String[] {"adj"})
        .put("bracketPair", new String[] {"adj"})
        .put("can", new String[] {"adj"})
        .put("chevron", new String[] {"adj"})
        .put("cube", new String[] {"adj"})
        .put("decadon", new String[] {"vf"})
        .put("diagStripe", new String[] {"adj"})
        .put("donut", new String[] {"adj"})
        .put("foldetCorner", new String[] {"adj"})
        .put("heptagon", new String[] {"hf", "vf"})
        .put("hexagon", new String[] {"adj", "vf"})
        .put("homePlate", new String[] {"adj"})
        .put("horizontalScroll", new String[] {"adj"})
        .put("leftBracket", new String[] {"adj"})
        .put("moon", new String[] {"adj"})
        .put("noSmooking", new String[] {"adj"})
        .put("octagon", new String[] {"adj"})
        .put("parallelogram", new String[] {"adj"})
        .put("pentagon", new String[] {"hf", "vf"})
        .put("plaque", new String[] {"adj"})
        .put("plus", new String[] {"adj"})
        .put("rightBracket", new String[] {"adj"})
        .put("round1Rect", new String[] {"adj"})
        .put("roundRect", new String[] {"adj"})
        .put("smileyFace", new String[] {"adj"})
        .put("snip1Rect", new String[] {"adj"})
        .put("star10", new String[] {"adj", "hf"})
        .put("star12", new String[] {"adj"})
        .put("star16", new String[] {"adj"})
        .put("star24", new String[] {"adj"})
        .put("star32", new String[] {"adj"})
        .put("star4", new String[] {"adj"})
        .put("star5", new String[] {"adj", "hf", "vf"})
        .put("star6", new String[] {"adj", "hf"})
        .put("star7", new String[] {"adj", "hf", "vf"})
        .put("star8", new String[] {"adj"})
        .put("sun", new String[] {"adj"})
        .put("swooshArrow", new String[] {"adj"})
        .put("teardrop", new String[] {"adj"})
        .put("trapezoid", new String[] {"adj"})
        .put("triangle", new String[] {"adj"})
        .put("verticalScroll", new String[] {"adj"})
        .build();
}
