/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@SuppressWarnings("serial")
public class OpAttrs implements Map<String, Object> {

    private Map<String, Object> map;

    public OpAttrs() {
        map = new HashMap<String, Object>();
    }

    public OpAttrs(int initialCapacity) {
        map = new HashMap<String, Object>(initialCapacity);
    }

    public OpAttrs(Map<String, Object> map) {
        this.map = map;
    }

    public String optString(String key) {
        final Object o = map.get(key);
        return o instanceof String ? (String)o : null;
    }

    @SuppressWarnings("unchecked")
	public OpAttrs getMap(String key, boolean forceCreate) {
        Object o = get(key);
		if(o instanceof OpAttrs) {
		    return (OpAttrs)o;
		}
		if(o instanceof Map) {
			return new OpAttrs((Map<String, Object>)o);
		}
		if(forceCreate) {
		    final OpAttrs op = new OpAttrs();
			map.put(key, op);
			return op;
		}
		return null;
	}

	@SuppressWarnings("rawtypes")
	public Object opt(String mapValue, String key) {
		final Object o = map.get(mapValue);
		if(o instanceof Map) {
			return ((Map)o).get(key);
		}
		return null;
	}

	@SuppressWarnings("rawtypes")
	public Object remove(String mapValue, String key) {
		final Object o = get(mapValue);
		if(o instanceof Map) {
			return ((Map)o).remove(key);
		}
		return null;
	}

	public void removeEmpty(String mapValue) {
	    final Object o = get(mapValue);
	    if(o instanceof Map&&((Map)o).isEmpty()) {
	        remove(mapValue);
	    }
	}

	public String removeString(String key) {
	    final Object o = remove(key);
	    return o instanceof String ? (String)o : null;
	}

	@Override
    public void clear() {
        map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return map.containsValue(value);
    }

    @Override
    public Set<java.util.Map.Entry<String, Object>> entrySet() {
        return map.entrySet();
    }

    @Override
    public Object get(Object key) {
        return map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return map.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        map.putAll(m);
    }

    @Override
    public Object remove(Object key) {
        return map.remove(key);
    }

    @Override
    public int size() {
        return map.size();
    }

    @Override
    public Collection<Object> values() {
        return map.values();
    }

/*
    @Override
    public String toString() {
        final Iterator<java.util.Map.Entry<String, Object>> mapIter = map.entrySet().iterator();
        final StringBuffer buffer = new StringBuffer();
        while(mapIter.hasNext()) {
            final java.util.Map.Entry<String, Object> mapEntry = mapIter.next();
            buffer.append(mapEntry.getKey() + "={");
            buffer.append(mapEntry.getValue().toString());
            buffer.append("}");
            if(mapIter.hasNext()) {
                buffer.append(", ");
            }
        }
        return buffer.toString();
    }
*/

    // is copying the content of each hashmap into dest.
    @SuppressWarnings({ "rawtypes", "unchecked" })
    public static void deepCopy(Map<String, Object> source, Map<String, Object> dest) {
        final Iterator<Entry<String, Object>> sourceIter = source.entrySet().iterator();
        while(sourceIter.hasNext()) {
            final Entry<String, Object> sourceEntry = sourceIter.next();
            if(sourceEntry.getValue() instanceof Map) {
                Object o = dest.get(sourceEntry.getKey());
                if(!(o instanceof Map)) {
                    o = new OpAttrs();
                    dest.put(sourceEntry.getKey(), o);
                }
                deepCopy((Map)sourceEntry.getValue(), (Map)o);
            }
            else {
                dest.put(sourceEntry.getKey(), sourceEntry.getValue());
            }
        }
    }

    /*
     * each source value that is not available within dest will be copied 
     */
    @SuppressWarnings({ "rawtypes", "unchecked" })
    public static void deepMerge(Map<String, Object> source, Map<String, Object> dest) {
        final Iterator<Entry<String, Object>> sourceIter = source.entrySet().iterator();
        while(sourceIter.hasNext()) {
            final Entry<String, Object> sourceEntry = sourceIter.next();
            if(sourceEntry.getValue() instanceof Map) {
                Object o = dest.get(sourceEntry.getKey());
                if(!(o instanceof Map)) {
                    o = new OpAttrs();
                    dest.put(sourceEntry.getKey(), o);
                }
                deepMerge((Map)sourceEntry.getValue(), (Map)o);
            }
            else if(!dest.containsKey(sourceEntry.getKey())) {
                dest.put(sourceEntry.getKey(), sourceEntry.getValue());
            }
        }
    }
}
