/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/drawinglayer/utils/imageutils',
    'globals/apphelper'
], function (ImageUtil, AppHelper) {

    'use strict';

    // static class ImageUtils ================================================

    describe('DrawingLayer module ImageUtils', function () {

        it('should exist', function () {
            expect(ImageUtil).to.be.an('object');
        });

        // the operations to be applied by the document model
        var OPERATIONS = [
            { name: 'setDocumentAttributes', attrs: { document: { cols: 5, rows: 10 } } },
            { name: 'insertAutoStyle', styleId: 'a0', attrs: {}, default: true },
            { name: 'insertSheet', sheet: 0, sheetName: 'Sheet1' }
        ];

        // initialize test document
        var app;
        AppHelper.createSpreadsheetApp('ooxml', OPERATIONS).done(function (application) {
            app = application;
        });

        describe('method "ImageUtil.calculateBitmapSettings"', function () {

            it('should exist', function () {
                expect(ImageUtil).to.respondTo('calculateBitmapSettings');
            });

            it('should return correct bitmap values for Spreadsheet app', function () {
                // image size w:20 cm in hmm
                var frameSize = 20000;
                var leadingCrop = -60;
                var trailingCrop = -40;
                var bitmapSettings = ImageUtil.calculateBitmapSettings(app, frameSize, leadingCrop, trailingCrop);
                expect(bitmapSettings).to.be.an('object');
                expect(bitmapSettings.offset).to.be.equal('30%');
                expect(bitmapSettings.size).to.be.equal('50%');

                //image size h: 10cm
                frameSize = 10000;
                leadingCrop = -70;
                trailingCrop = -30;
                bitmapSettings = ImageUtil.calculateBitmapSettings(app, frameSize, leadingCrop, trailingCrop);
                expect(bitmapSettings).to.be.an('object');
                expect(bitmapSettings.offset).to.be.equal('35%');
                expect(bitmapSettings.size).to.be.equal('50%');
            });

        });
    });

    // ========================================================================
});
