
'use strict';

module.exports = function (grunt) {

    // displays the execution time of grunt tasks
    //     if (grunt.option('benchmark') || grunt.config('local.benchmark')) require('time-grunt')(grunt);

    // linter tasks (working on original source code before copy tasks)
    grunt.registerTask('lint', ['newer:eslint', 'newer:jsonlint', 'newer:reqlint', 'newer:lhlint']);
    // steps to build the ui (ready for development)
    grunt.registerTask('build', ['lint', 'copy_build', 'newer:webfonts', 'newer:iconsets', 'newer:formulares', 'newer:concat', 'newer:less', 'compile_po']);
    // create a distribution ready version of the ui
    grunt.registerTask('dist', ['clean', 'build', 'copy_dist', 'uglify']);
    // default task (grunt called without target)
    grunt.registerTask('default', ['build']);
};
