/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/tk/dialogs', [
    'io.ox/office/tk/dialog/basedialog',
    'io.ox/office/tk/dialog/tabbeddialog',
    'io.ox/office/tk/dialog/messagedialog',
    'io.ox/office/tk/dialog/querydialog',
    'io.ox/office/tk/dialog/inputdialog'
], function (BaseDialog, TabbedDialog, MessageDialog, QueryDialog, InputDialog) {

    'use strict';

    // static class Dialogs ===================================================

    /**
     * Provides different types of generic dialogs. Collects all standard
     * dialog classes defined in the toolkit in a single map for convenience.
     */
    var Dialogs = {
        BaseDialog: BaseDialog,
        TabbedDialog: TabbedDialog,
        MessageDialog: MessageDialog,
        QueryDialog: QueryDialog,
        InputDialog: InputDialog
    };

    // static methods ---------------------------------------------------------

    /**
     * Returns the root node of the modal dialog that is currently open. In
     * case multiple dialogs are open (stacked), the root node of the top-most
     * dialog will be returned.
     *
     * @returns {jQuery}
     *  The root node of the modal dialog that is currently open, as jQuery
     *  object. If no modal dialog is currently open, an empty jQuery
     *  collection will be returned instead.
     */
    Dialogs.getActiveDialogNode = function () {
        return $('.io-ox-dialog-popup').last();
    };

    /**
     * Returns whether a modal dialog is currently open.
     *
     * @returns {Boolean}
     *  Whether a modal dialog is currently open.
     */
    Dialogs.isDialogOpen = function () {
        return Dialogs.getActiveDialogNode().length > 0;
    };

    // exports ================================================================

    return Dialogs;

});
