/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/textframework/view/control/commentfiltergroup', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/checkgroup'
], function (Utils, CheckGroup) {

    'use strict';

    // class CommentFilterGroup ==============================================

    /**
     * A check-list group control that shows all comment authors.
     *
     * @constructor
     *
     * @extends CheckGroup
     */
    function CommentFilterGroup(docView) {

        // self reference
        var self = this;

        // the comments in the document model
        var commentLayer = docView.getDocModel().getCommentLayer();

        // base constructor ---------------------------------------------------

        CheckGroup.call(this, docView, { matcher: matcher, sorted: sortComparator, boxed: false, checkAll: true });

        // private methods ----------------------------------------------------

        /**
         * A case-insensitive list item matcher.
         */
        function matcher(value, entry) {
            return _.isString(value) && (value.toLowerCase() === entry.toLowerCase());
        }

        /**
         * Compares the passed author names.
         */
        function sortComparator(str1, str2) {
            return (str1 < str2) ? -1 : (str1 > str2) ? 1 : 0;
        }

        /**
         * Generating one button for each comment author.
         */
        function updateAuthorList() {

            var // the list of all comment authors
                allAuthors = commentLayer.getListOfCommentAuthors();

            self.clearOptionButtons();

            // insert the new entries into the list
            _.each(allAuthors, function (oneAuthor) {
                self.createOptionButton(oneAuthor, { label: _.noI18n(oneAuthor), sortIndex: oneAuthor });
            });
        }

        // initialization -----------------------------------------------------

        // register listener for comment layer notification if list of authors is modified
        this.listenTo(commentLayer, 'update:commentauthorlist', updateAuthorList);

        // destroy all class members on destruction
        this.registerDestructor(function () {
            self = docView = commentLayer = null;
        });

    } // class CommentFilterGroup

    // exports ================================================================

    // derive this class from class CheckGroup
    return CheckGroup.extend({ constructor: CommentFilterGroup });

});
