/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/shapemodel', [
    'io.ox/office/drawinglayer/model/shapemodel',
    'io.ox/office/spreadsheet/model/drawing/drawingmodelmixin'
], function (ShapeModel, DrawingModelMixin) {

    'use strict';

    // class SheetShapeModel ==================================================

    /**
     * The model of a shape object contained in a sheet.
     *
     * @constructor
     *
     * @extends ShapeModel
     * @extends DrawingModelMixin
     *
     * @param {SheetModel} sheetModel
     *  The sheet model instance containing this shape object.
     *
     * @param {DrawingCollection} parentCollection
     *  The parent drawing collection that will contain this drawing object.
     *
     * @param {Object} [initAttributes]
     *  An attribute set with initial formatting attributes for the object.
     */
    var SheetShapeModel = ShapeModel.extend({ constructor: function (sheetModel, parentCollection, initAttributes) {

        // base constructors --------------------------------------------------

        ShapeModel.call(this, parentCollection, initAttributes);
        DrawingModelMixin.call(this, sheetModel, cloneConstructor);

        // private methods ----------------------------------------------------

        /**
         * Returns a clone of this shape model for the specified sheet. Used by
         * the implementation of the public clone() method defined by the class
         * DrawingModelMixin.
         *
         * @param {SheetModel} targetModel
         *  The sheet model that will contain the cloned shape model.
         *
         * @param {DrawingCollection} targetCollection
         *  The drawing collection that will contain the cloned shape model.
         *
         * @returns {SheetShapeModel}
         *  A clone of this shape model, initialized for ownership by the
         *  passed target drawing collection.
         */
        function cloneConstructor(targetModel, targetCollection) {
            return new SheetShapeModel(targetModel, targetCollection, this.getExplicitAttributeSet(true));
        }

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            sheetModel = parentCollection = initAttributes = null;
        });

    } }); // class SheetShapeModel

    // exports ================================================================

    return SheetShapeModel;

});
