/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/drawingmodel', [
    'io.ox/office/drawinglayer/model/drawingmodel',
    'io.ox/office/spreadsheet/model/drawing/drawingmodelmixin'
], function (DrawingModel, DrawingModelMixin) {

    'use strict';

    // class SheetDrawingModel ================================================

    /**
     * The model of a generic drawing object contained in a sheet.
     *
     * @constructor
     *
     * @extends DrawingModel
     * @extends DrawingModelMixin
     *
     * @param {SheetModel} sheetModel
     *  The sheet model instance containing this drawing object.
     *
     * @param {DrawingCollection} parentCollection
     *  The parent drawing collection that will contain this drawing object.
     *
     * @param {String} drawingType
     *  The type of this drawing object.
     *
     * @param {Object} [initAttributes]
     *  An attribute set with initial formatting attributes for the object.
     */
    var SheetDrawingModel = DrawingModel.extend({ constructor: function (sheetModel, parentCollection, drawingType, initAttributes) {

        // base constructors --------------------------------------------------

        DrawingModel.call(this, parentCollection, drawingType, initAttributes);
        DrawingModelMixin.call(this, sheetModel, cloneConstructor);

        // private methods ----------------------------------------------------

        function cloneConstructor(targetModel, targetCollection) {
            return new SheetDrawingModel(targetModel, targetCollection, drawingType, this.getExplicitAttributeSet(true));
        }

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            sheetModel = parentCollection = initAttributes = null;
        });

    } }); // class SheetDrawingModel

    // exports ================================================================

    return SheetDrawingModel;

});
