/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

/* eslint no-new: 0 */

define('io.ox/office/portal/register', [
    'io.ox/core/desktop',
    'io.ox/core/extPatterns/stage',
    'gettext!io.ox/office/portal/main'
], function (ui, Stage, gt) {
    'use strict';

    new Stage('io.ox/core/stages', {
        id: 'office_apps',
        after: 'app_register',
        run: function () {
            ui.createApp({
                id: 'io.ox/office/portal/text',
                name: 'io.ox/office/portal/text',
                title: gt.pgettext('app', 'Text'),
                icon: '<i class="fa fa-file-text-o">',
                requires: 'text !textportaldisabled !DeniedPortal infostore !guest',
                settings: false,
                refreshable: true
            });
            ui.createApp({
                id: 'io.ox/office/portal/spreadsheet',
                name: 'io.ox/office/portal/spreadsheet',
                title: gt.pgettext('app', 'Spreadsheet'),
                icon: '<i class="fa fa-table">',
                requires: 'spreadsheet !spreadsheetportaldisabled !DeniedPortal infostore !guest',
                settings: false,
                refreshable: true
            });
            ui.createApp({
                id: 'io.ox/office/portal/presentation',
                name: 'io.ox/office/portal/presentation',
                title: gt.pgettext('app', 'Presentation'),
                icon: '<i class="fa fa-list-alt">',
                requires: 'presentation !presentationportaldisabled !DeniedPortal infostore !guest',
                settings: false,
                refreshable: true
            });
            ui.createApp({
                name: 'io.ox/office/text',
                settings: false,
                refreshable: true,
                requires: 'text infostore'
            });
            ui.createApp({
                name: 'io.ox/office/spreadsheet',
                requires: 'spreadsheet infostore',
                settings: false,
                refreshable: true
            });
            ui.createApp({
                name: 'io.ox/office/presentation',
                requires: 'presentation infostore',
                settings: false,
                refreshable: true
            });
            ui.createApp({
                name: 'io.ox/office/presenter',
                requires: 'presenter',
                settings: false,
                refreshable: true
            });
        }
    });
});
