/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Mario Schroeder <mario.schroeder@open-xchange.com>
 */

define('io.ox/office/editframework/view/dialog/clipboardnoticedialog', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/dialog/basedialog',
    'io.ox/office/editframework/view/editlabels',
    'gettext!io.ox/office/editframework/main'
], function (Utils, BaseDialog, Labels, gt) {

    'use strict';

    //#. The OS depending modifier key to press along with X, C and V for cut, copy and paste.
    //#. Ctrl key on Windows and Linux systems, Cmd key on Apple Mac.
    //#. The Cmd key is represented as the corresponding unicode char U+2318.
    var MODIFIER_KEY = _.device('MacOS || iOS') ? _.noI18n('\u2318') : gt('Ctrl');

    // class ClipboardNoticeDialog ============================================

    /**
     * A modal dialog that displays a message informing that clipboard
     * paste is possible via keyboard command only.
     *
     * @constructor
     *
     * @extends BaseDialog
     *
     * @param {EditView} docView
     *  The document view instance that has created this dialog.
     *
     * @param {Object} [initOptions]
     *  Additional options handed over to the BaseDialog base class.
     */
    var ClipboardNoticeDialog = BaseDialog.extend(function (docView, initOptions) {

        // base constructor
        BaseDialog.call(this, docView, _.extend({
            width: 420,
            /*#. The title of the cut, copy and paste keyboard shortcut notice dialog. */
            title: gt('Cut, copy and paste')
        }, initOptions));

        // remove the Cancel button
        this.getCancelButton().hide();

        // add the input controls to the dialog body
        this.append(
            $('<div class="form-group">').append(
                $('<div>').text(gt('Some actions are unavailable via the context menu. Please use these shortcuts:'))
            ),
            $('<div class="form-group">').append(
                $('<h4>').append(
                    $('<span class="fa fa-fw fa-cut">&nbsp;</span>'),
                    $('<span>').text(/*#. Keyboard shortcut advice for cut*/ gt('Cut = %1$s + X', MODIFIER_KEY))
                ),
                $('<h4>').append(
                    $('<span class="fa fa-fw fa-copy">&nbsp;</span>'),
                    $('<span>').text(/*#. Keyboard shortcut advice for copy*/ gt('Copy = %1$s + C', MODIFIER_KEY))
                ),
                $('<h4>').append(
                    $('<span class="fa fa-fw fa-paste">&nbsp;</span>'),
                    $('<span>').text(/*#. Keyboard shortcut advice for paste*/ gt('Paste = %1$s + V', MODIFIER_KEY))
                )
            )
        );

        this.registerDestructor(function () {
            docView.getDocModel().getSelection().restoreBrowserSelection({ forceWhenReadOnly: true });
        });

    }); // class ClipboardNoticeDialog

    // exports ================================================================

    return ClipboardNoticeDialog;
});
