/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/view/popup/chartlabelsmenu', [
    'io.ox/office/tk/control/checkbox',
    'io.ox/office/tk/control/textfield',
    'io.ox/office/drawinglayer/view/popup/drawingframemenu',
    'gettext!io.ox/office/drawinglayer/main'
], function (CheckBox, TextField, DrawingFrameMenu, gt) {

    'use strict';

    // menu titles for axis menus
    var CHART_AXIS_HEADER_OPTIONS_LABELS = {
        x: /*#. menu title: options for the X axis (categories) in a chart object */ gt.pgettext('menu-title', 'X axis options'),
        y: /*#. menu title: options for the Y axis (values) in a chart object */ gt.pgettext('menu-title', 'Y axis options'),
        z: /*#. menu title: options for the Z axis (deep axis in 3D charts) in a chart object */ gt.pgettext('menu-title', 'Z axis options')
    };

    // menu titles for axis menus
    var CHART_AXIS_HEADER_TITLE_LABELS = {
        x: /*#. menu title: functions for the X axis title (categories) in a chart object */ gt.pgettext('menu-title', 'X axis title'),
        y: /*#. menu title: functions for the Y axis title (values) in a chart object */ gt.pgettext('menu-title', 'Y axis title'),
        z: /*#. menu title: functions for the Z axis title (deep axis in 3D charts) in a chart object */ gt.pgettext('menu-title', 'Z axis title')
    };

    // options for text fields for chart titles
    var CHART_TITLE_TEXTFIELD_OPTIONS = {
        minWidth: 200,
        placeholder: /*#. default placeholder for editing the main title in chart objects */ gt.pgettext('chart-format', 'Type text to add a title'),
        select: true
    };

    // class ChartLabelsMenu ==================================================

    /**
     * A floating menu with options for axes and labels in a chart object.
     *
     * @constructor
     *
     * @extends DrawingFrameMenu
     *
     * @param {EditView} docView
     *  The document view that contains this instance.
     */
    function ChartLabelsMenu(docView, initOptions) {

        // base constructor ---------------------------------------------------

        //#. menu title: modify settings for chart objects
        DrawingFrameMenu.call(this, docView, 'chart', gt.pgettext('menu-title', 'Labels & Axes'), initOptions);

        // initialization -----------------------------------------------------

        // add base menu items
        this.addSectionLabel(gt.pgettext('menu-title', 'Chart title'), { separator: false });
        this.addGroup('drawing/chart/title/text', new TextField(docView, CHART_TITLE_TEXTFIELD_OPTIONS));

        // add menu items for X and Y axis
        _.each('xy', function (axisId) {

            // the base path of axis items
            var keyPath = 'drawing/chart/axis/' + axisId + '/';

            this.addSectionLabel(CHART_AXIS_HEADER_TITLE_LABELS[axisId])
                .addGroup(keyPath + 'title/text', new TextField(docView, CHART_TITLE_TEXTFIELD_OPTIONS))
                .addSectionLabel(CHART_AXIS_HEADER_OPTIONS_LABELS[axisId])
                .addGroup(keyPath + 'labels/visible', new CheckBox(docView, {
                    //#. (check box) show/hide the caption labels (e.g. the scaling numbers) on an axis in chart objects
                    label: gt.pgettext('chart-format', 'Labels'),
                    boxed: true
                }))
                .addGroup(keyPath + 'line/visible', new CheckBox(docView, {
                    //#. (check box) show/hide the axis line in chart objects
                    label: gt.pgettext('chart-format', 'Axis line'),
                    boxed: true
                }))
                .addGroup(keyPath + 'grid/visible', new CheckBox(docView, {
                    //#. (check box) show/hide the grid lines for a specific direction in chart objects
                    label: gt.pgettext('chart-format', 'Grid lines'),
                    boxed: true
                }));
        }, this);

        // destroy all class members
        this.registerDestructor(function () {
            docView = initOptions = null;
        });

    } // class ChartLabelsMenu

    // exports ================================================================

    // derive this class from class DrawingFrameMenu
    return DrawingFrameMenu.extend({ constructor: ChartLabelsMenu });

});
