/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/view/basecontrols', [
    'io.ox/office/tk/controls',
    'io.ox/office/baseframework/view/control/dynamiclabel',
    'io.ox/office/baseframework/view/control/percentagelabel',
    'io.ox/office/baseframework/view/control/userpicture',
    'io.ox/office/baseframework/view/control/compoundbutton',
    'io.ox/office/baseframework/view/control/compoundsplitbutton',
    'io.ox/office/baseframework/view/control/compoundcheckbox',
    'io.ox/office/baseframework/view/control/sharebutton'
], function (Controls, DynamicLabel, PercentageLabel, UserPicture, CompoundButton, CompoundSplitButton, CompoundCheckBox, ShareButton) {

    'use strict';

    // static class BaseControls ==============================================

    /**
     * Provides different classes for GUI form controls. Collects all standard
     * control group classes defined in the toolkit, and adds more controls in
     * a single map for convenience.
     *
     * @extends Controls
     */
    var BaseControls = _.extend({}, Controls, {
        DynamicLabel: DynamicLabel,
        PercentageLabel: PercentageLabel,
        UserPicture: UserPicture,
        CompoundButton: CompoundButton,
        CompoundSplitButton: CompoundSplitButton,
        CompoundCheckBox: CompoundCheckBox,
        ShareButton: ShareButton
    });

    // exports ================================================================

    return BaseControls;

});
