/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/textframework/view/dialogs', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/forms',
    'io.ox/office/editframework/view/editdialogs',
    'io.ox/office/textframework/view/dialog/pagesettingsdialog'
], function (Utils, Forms, EditDialogs, PageSettingsDialog) {

    'use strict';

    // class InputValidateDialog ===============================================

    var InputValidateDialog = EditDialogs.InputDialog.extend(function (docView, initOptions) {

        var warningNode = $('<div style="margin:5px 0 13px;font-size:13px;">');
        var validator = Utils.getFunctionOption(initOptions, 'validator');

        // base constructor ---------------------------------------------------

        EditDialogs.InputDialog.call(this, docView, initOptions);

        // initialization -----------------------------------------------------

        // add the warning label to the dialog body
        this.append(warningNode);

        // close dialog when losing edit rights
        docView.closeDialogOnReadOnlyMode(this);

        // update the warning label after every change of the text input field
        this.addOkValidator(function () {
            var warningText = validator ? validator(this.getText()) : null;
            if (warningText) {
                warningNode.empty().append(
                    Forms.createIconMarkup('fa-warning', { style: 'margin-left:3px;color:#eb0;' }),
                    $('<span style="margin-left:5px;">').text(warningText)
                );
            } else {
                warningNode.text('\xa0');
            }
            return !warningText;
        });

    }); // class InputValidateDialog

    // static class TextDialogs ===============================================

    /**
     * Additional classes defining specialized modal dialogs for the text editor
     * application.
     *
     * @extends EditDialogs
     */
    var TextDialogs = _.extend({}, EditDialogs, {
        InputValidateDialog: InputValidateDialog,
        PageSettingsDialog: PageSettingsDialog
    });

    // exports ================================================================

    return TextDialogs;

});
