/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/groupmodel', [
    'io.ox/office/drawinglayer/model/groupmodel',
    'io.ox/office/spreadsheet/model/drawing/drawingmodelmixin'
], function (GroupModel, DrawingModelMixin) {

    'use strict';

    // class SheetGroupModel ==================================================

    /**
     * The model of a group object contained in a sheet.
     *
     * @constructor
     *
     * @extends GroupModel
     * @extends DrawingModelMixin
     *
     * @param {SheetModel} sheetModel
     *  The sheet model instance containing this group object.
     *
     * @param {DrawingCollection} parentCollection
     *  The parent drawing collection that will contain this drawing object.
     *
     * @param {Object} [initAttributes]
     *  An attribute set with initial formatting attributes for the object.
     */
    var SheetGroupModel = GroupModel.extend({ constructor: function (sheetModel, parentCollection, initAttributes) {

        // base constructors --------------------------------------------------

        GroupModel.call(this, parentCollection, initAttributes);
        DrawingModelMixin.call(this, sheetModel, cloneConstructor);

        // private methods ----------------------------------------------------

        /**
         * Returns a clone of this group model for the specified sheet. Used by
         * the implementation of the public clone() method defined by the class
         * DrawingModelMixin.
         *
         * @param {SheetModel} targetModel
         *  The sheet model that will contain the cloned group model.
         *
         * @param {DrawingCollection} targetCollection
         *  The drawing collection that will contain the cloned group model.
         *
         * @returns {SheetGroupModel}
         *  A clone of this group model, initialized for ownership by the
         *  passed target drawing collection.
         */
        function cloneConstructor(targetModel, targetCollection) {
            return new SheetGroupModel(targetModel, targetCollection, this.getExplicitAttributeSet(true));
        }

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            sheetModel = parentCollection = initAttributes = null;
        });

    } }); // class SheetGroupModel

    // exports ================================================================

    return SheetGroupModel;

});
