/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/settings/templatemodel', [
    'io.ox/office/tk/config'
], function (Config) {

    'use strict';

    /**
     *
     * User-Model-Data
     * for Template folders
     * the folder-ids are saved in one array, and it is checked for double entries!
     *
     */
    function Model(key) {
        var self = this;

        function set(list) {
            // we must set it first to null, to delete it, because arrays are merged
            // Bug 53053
            Config.set(key, null).done(function () {
                Config.set(key, list);
            });
        }

        /**
         * returns all template folder-ids in one array
         */
        this.getAll = function () {
            return Config.getArray(key);
        };

        /**
         * adds the folder-id to the account,
         * double entries will be ignored and return false
         * new entries return true
         */
        this.add = function (folderId) {
            var list = self.getAll();
            var len = list.length;
            list.push(folderId);
            list = _.unique(list);
            set(list);

            return len !== list.length;
        };

        /**
         * tries to remove folder-id from the account data
         * if id is not in the list, false will be returned and no changes are saved
         * if deletion is successful, it is saved and returns true
         */
        this.remove = function (folderId) {
            var list = self.getAll();
            var index = list.indexOf(folderId);
            if (index < 0) {
                return false;
            }
            list.splice(index, 1);
            set(list);
            return true;
        };
    }

    return Model;

});
