/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/editcontrols', [
    'io.ox/office/tk/utils',
    'io.ox/office/baseframework/view/basecontrols',
    'io.ox/office/drawinglayer/view/drawingcontrols',
    'io.ox/office/editframework/view/editlabels',
    'io.ox/office/editframework/view/control/applicationstatuslabel',
    'io.ox/office/editframework/view/control/acquireeditbutton',
    'io.ox/office/editframework/view/control/filenamefield',
    'io.ox/office/editframework/view/control/colorpicker',
    'io.ox/office/editframework/view/control/bordermodepicker',
    'io.ox/office/editframework/view/control/borderstylepicker',
    'io.ox/office/editframework/view/control/borderwidthpicker',
    'io.ox/office/editframework/view/control/fontfamilypicker',
    'io.ox/office/editframework/view/control/fontsizepicker',
    'io.ox/office/editframework/view/control/stylesheetpicker',
    'io.ox/office/editframework/view/control/languagepicker',
    'io.ox/office/editframework/view/control/tablesizepicker',
    'io.ox/office/editframework/view/control/tablestylepicker',
    'io.ox/office/editframework/view/control/userbadge',
    'io.ox/office/editframework/view/control/toolbartabgroup',
    'io.ox/office/editframework/view/control/toolbartablist',
    'gettext!io.ox/office/editframework/main'
], function (Utils, BaseControls, DrawingControls, EditLabels, ApplicationStatusLabel, AcquireEditButton, FileNameField, ColorPicker, BorderModePicker, BorderStylePicker, BorderWidthPicker, FontFamilyPicker, FontSizePicker, StyleSheetPicker, LanguagePicker, TableSizePicker, TableStylePicker, UserBadge, ToolBarTabGroup, ToolBarTabList, gt) {

    'use strict';

    // static class EditControls ==============================================

    /**
     * Provides different classes for GUI form controls. Collects all standard
     * control group classes defined in the toolkit, and adds more controls in
     * a single map for convenience.
     *
     * @extends BaseControls
     * @extends DrawingControls
     */
    var EditControls = _.extend({}, BaseControls, DrawingControls, {
        ApplicationStatusLabel: ApplicationStatusLabel,
        AcquireEditButton: AcquireEditButton,
        FileNameField: FileNameField,
        ColorPicker: ColorPicker,
        BorderModePicker: BorderModePicker,
        BorderStylePicker: BorderStylePicker,
        BorderWidthPicker: BorderWidthPicker,
        FontFamilyPicker: FontFamilyPicker,
        FontSizePicker: FontSizePicker,
        StyleSheetPicker: StyleSheetPicker,
        LanguagePicker: LanguagePicker,
        TableSizePicker: TableSizePicker,
        TableStylePicker: TableStylePicker,
        UserBadge: UserBadge,
        ToolBarTabGroup: ToolBarTabGroup,
        ToolBarTabList: ToolBarTabList
    });

    // class TextColorPicker ==================================================

    /**
     * A color picker control for selecting a text color. The list entry for
     * the automatic color will be shown as 'Black' by default, but can be
     * changed with the method ColorPicker.setAutoColor().
     *
     * @constructor
     *
     * @extends ColorPicker
     *
     * @param {EditView} docView
     *  The document view that contains this color picker.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options of the ColorPicker base
     *  class.
     */
    EditControls.TextColorPicker = ColorPicker.extend({ constructor: function (docView, initOptions) {

        ColorPicker.call(this, docView, 'text', Utils.extendOptions(EditLabels.TEXT_COLORPICKER_OPTIONS, initOptions));

    } }); // class TextColorPicker

    // class FillColorPicker ==================================================

    /**
     * A color picker control for selecting a fill color. The list entry for
     * the automatic color will be shown as 'No fill' by default, but can be
     * changed with the method ColorPicker.setAutoColor().
     *
     * @constructor
     *
     * @extends ColorPicker
     *
     * @param {EditView} docView
     *  The document view that contains this color picker.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options of the ColorPicker base
     *  class.
     */
    EditControls.FillColorPicker = ColorPicker.extend({ constructor: function (docView, initOptions) {

        ColorPicker.call(this, docView, 'fill', Utils.extendOptions(EditLabels.FILL_COLORPICKER_OPTIONS, initOptions));

    } }); // class FillColorPicker

    // class BorderColorPicker ==================================================

    /**
     * A color picker control for selecting a border color.
     *
     * @constructor
     *
     * @extends ColorPicker
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options of the RadioList base class
     */
    EditControls.BorderColorPicker = ColorPicker.extend({ constructor: function (docView, initOptions) {

        ColorPicker.call(this, docView, null, Utils.extendOptions(EditLabels.BORDER_COLORPICKER_OPTIONS, initOptions));

    } }); // class BorderColorPicker

    // class BorderPresetStylePicker ==========================================

    // predefined border styles (line width, line style) supported by OOXML
    var BORDER_OOXML_PRESET_STYLES = [
        { value: 'none:none',         label: /*#. border line style (no border) */ gt.pgettext('borders', 'No line'),                                         style: 'none' },
        { value: 'solid:hair',        label: /*#. border line style (width 0.5 pixels, solid) */ gt.pgettext('borders', 'Hair line'),                         style: 'solid',      width: 0 },
        { value: 'solid:thin',        label: /*#. border line style (width 1 pixel, solid) */ gt.pgettext('borders', 'Thin line'),                            style: 'solid',      width: 1 },
        { value: 'dashed:thin',       label: /*#. border line style (width 1 pixel, dashed) */ gt.pgettext('borders', 'Dashed thin line'),                    style: 'dashed',     width: 1 },
        { value: 'dotted:thin',       label: /*#. border line style (width 1 pixel, dotted) */ gt.pgettext('borders', 'Dotted thin line'),                    style: 'dotted',     width: 1 },
        { value: 'dashDot:thin',      label: /*#. border line style (width 1 pixel, dash-dot) */ gt.pgettext('borders', 'Dot-and-dash thin line'),            style: 'dashDot',    width: 1 },
        { value: 'dashDotDot:thin',   label: /*#. border line style (width 1 pixel, dash-dot-dot) */ gt.pgettext('borders', 'Two-dots-and-dash thin line'),   style: 'dashDotDot', width: 1 },
        { value: 'solid:medium',      label: /*#. border line style (width 2 pixels, solid) */ gt.pgettext('borders', 'Medium line'),                         style: 'solid',      width: 2 },
        { value: 'dashed:medium',     label: /*#. border line style (width 2 pixels, dashed) */ gt.pgettext('borders', 'Dashed medium line'),                 style: 'dashed',     width: 2 },
        { value: 'dotted:medium',     label: /*#. border line style (width 2 pixel, dotted) */ gt.pgettext('borders', 'Dotted medium line'),                  style: 'dotted',     width: 2 },
        { value: 'dashDot:medium',    label: /*#. border line style (width 2 pixel, dash-dot) */ gt.pgettext('borders', 'Dot-and-dash medium line'),          style: 'dashDot',    width: 2 },
        { value: 'dashDotDot:medium', label: /*#. border line style (width 2 pixel, dash-dot-dot) */ gt.pgettext('borders', 'Two-dots-and-dash medium line'), style: 'dashDotDot', width: 2 },
        { value: 'solid:thick',       label: /*#. border line style (width 3 pixels, solid) */ gt.pgettext('borders', 'Thick line'),                          style: 'solid',      width: 3 }
    ];

    // predefined border styles (line width, line style) supported by ODF
    var BORDER_ODF_PRESET_STYLES = [
        { value: 'none:none',         label: /*#. border line style (width 0.5 pixels, solid) */ gt.pgettext('borders', 'No line'),                           style: 'none' },
        { value: 'solid:hair',        label: /*#. border line style (width 0.5 pixels, solid) */ gt.pgettext('borders', 'Hair line'),                         style: 'solid',  width: 0 },
        { value: 'solid:thin',        label: /*#. border line style (width 1 pixel, solid) */ gt.pgettext('borders', 'Thin line'),                            style: 'solid',  width: 1 },
        { value: 'dashed:thin',       label: /*#. border line style (width 1 pixel, dashed) */ gt.pgettext('borders', 'Dashed thin line'),                    style: 'dashed', width: 1 },
        { value: 'dotted:thin',       label: /*#. border line style (width 1 pixel, dotted) */ gt.pgettext('borders', 'Dotted thin line'),                    style: 'dotted', width: 1 },
        { value: 'solid:medium',      label: /*#. border line style (width 2 pixels, solid) */ gt.pgettext('borders', 'Medium line'),                         style: 'solid',  width: 2 },
        { value: 'dashed:medium',     label: /*#. border line style (width 2 pixels, dashed) */ gt.pgettext('borders', 'Dashed medium line'),                 style: 'dashed', width: 2 },
        { value: 'dotted:medium',     label: /*#. border line style (width 2 pixel, dotted) */ gt.pgettext('borders', 'Dotted medium line'),                  style: 'dotted', width: 2 },
        { value: 'solid:thick',       label: /*#. border line style (width 3 pixels, solid) */ gt.pgettext('borders', 'Thick line'),                          style: 'solid',  width: 3 }
    ];

    /**
     * A drop-down list control for border line styles used in OOXML files.
     *
     * @constructor
     *
     * @extends EditControls.BorderStylePicker
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options supported by the base class
     *  EditControls.BorderStylePicker.
     */
    EditControls.BorderPresetStylePicker = EditControls.BorderStylePicker.extend({ constructor: function (docView, initOptions) {

        var PRESET_STYLES = docView.getApp().isODF() ? BORDER_ODF_PRESET_STYLES : BORDER_OOXML_PRESET_STYLES;

        EditControls.BorderStylePicker.call(this, docView, PRESET_STYLES, Utils.extendOptions({
            label: EditLabels.BORDER_STYLE_LABEL,
            smallerVersion: { hideLabel: true }
        }, initOptions));

    } }); // class BorderPresetStylePicker

    // exports ================================================================

    return EditControls;

});
