/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/view/control/sharebutton', [
    'io.ox/office/tk/utils/shareutils',
    'io.ox/office/tk/control/button',
    'io.ox/office/tk/control/label',
    'io.ox/office/baseframework/view/control/compoundbutton'
], function (ShareUtils, Button, Label, CompoundButton) {

    'use strict';

    // class ShareButton ======================================================

    /**
     * Button with drop-down menu for sharing features "Create sharing link" & "Invite people"
     *
     * creates the two buttons with a detailed description
     * coming from the original extension-points
     *
     * @constructor
     *
     * @extends CompoundButton
     */
    var ShareButton = CompoundButton.extend({ constructor: function (docView, tooltip) {

        var self = this;
        var labelsForShareLink = ShareUtils.getLabelsForShareLink();
        var labelsForInviteUser = ShareUtils.getLabelsForinviteUser();

        // base constructor ---------------------------------------------------

        CompoundButton.call(this, docView, {
            icon:            'fa-user-plus',
            classes:         'link-style',
            tooltip:         tooltip
        });

        // private functions --------------------------------------------------

        function makeButtonWithLabel(controllerKey, labelsHolder) {

            self.addGroup(controllerKey, new Button(docView, { label: labelsHolder.label, classes: 'hidedisabled' }));

            var label = new Label(docView, { label: labelsHolder.description, classes: 'hidedisabled' });
            label.getLabelNode().removeClass('label').addClass('dropdown-header dropdown-description');

            self.addGroup(controllerKey, label);
        }

        // initialization -----------------------------------------------------

        makeButtonWithLabel('document/share/inviteuser', labelsForInviteUser);
        makeButtonWithLabel('document/share/getlink', labelsForShareLink);

    } }); // class ShareButton

    // exports ================================================================

    return ShareButton;

});
