/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.im4java.process.ErrorConsumer;
import org.im4java.process.InputProvider;
import org.im4java.process.OutputConsumer;

public class Pipe
implements InputProvider,
OutputConsumer,
ErrorConsumer {
    public static final int BUFFER_SIZE = 65536;
    private InputStream iSource;
    private OutputStream iSink;

    public Pipe(InputStream inputStream, OutputStream outputStream) {
        this.iSource = inputStream;
        this.iSink = outputStream;
    }

    @Override
    public void provideInput(OutputStream outputStream) throws IOException {
        this.copyBytes(this.iSource, outputStream);
    }

    @Override
    public void consumeOutput(InputStream inputStream) throws IOException {
        if (this.iSink != null) {
            this.copyBytes(inputStream, this.iSink);
        }
    }

    @Override
    public void consumeError(InputStream inputStream) throws IOException {
        if (this.iSink != null) {
            this.copyBytes(inputStream, this.iSink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) != -1) {
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                outputStream.write(byArray, 0, n);
            }
        }
        outputStream.flush();
    }
}

