/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ant.tasks;

import com.openexchange.config.docu.parser.DocumentationGenerator;
import com.openexchange.config.docu.parser.JSONGenerator;
import com.openexchange.config.docu.parser.JSONPrepared;
import com.openexchange.config.docu.parser.Parser;
import com.openexchange.config.docu.parser.PropertiesGenerator;
import com.openexchange.config.docu.parser.Property;
import com.openexchange.config.docu.parser.YamlFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GenerateConfigDoc
extends Task {
    private String inputdir;
    private String outputdir;
    private String version;
    private String format;
    private String packagename;

    public void setInputdir(String id) {
        this.inputdir = id;
    }

    public void setOutputdir(String od) {
        this.outputdir = od;
    }

    public void setVersion(String vers) {
        this.version = vers;
    }

    public void setFormat(String f) {
        this.format = f;
    }

    public void setPackagename(String p) {
        this.packagename = p;
    }

    public void execute() throws BuildException {
        if (GenerateConfigDoc.isNullOrEmpty(this.inputdir)) {
            throw new BuildException("Please define the inputdir.");
        }
        if (GenerateConfigDoc.isNullOrEmpty(this.outputdir)) {
            throw new BuildException("Please define the outputdir.");
        }
        File yamlFolder = new File(this.inputdir);
        if (!yamlFolder.exists() || !yamlFolder.isDirectory()) {
            throw new BuildException("Input Folder doesn't exist or is not a folder!");
        }
        File outputFolder = new File(this.outputdir);
        if (!outputFolder.exists() || !outputFolder.isDirectory()) {
            throw new BuildException("Output Folder doesn't exist or is not a folder!");
        }
        if (!"json".equals(this.format) && !"properties".equals(this.format)) {
            throw new BuildException("Invalid output format '" + this.format + "' please choose 'json' or 'properties'");
        }
        if ("json".equals(this.format) && GenerateConfigDoc.isNullOrEmpty(this.version)) {
            throw new BuildException("Please define the version.");
        }
        try {
            DocumentationGenerator<JSONPrepared> docsGenerator;
            LinkedList<String> allPackageNames = new LinkedList<String>();
            List<YamlFile> YamlFiles = Parser.getYamlData(this.inputdir);
            for (YamlFile yamlfile : YamlFiles) {
                for (Property propertie : yamlfile.getProperties()) {
                    String nametoadd = propertie.getPackageName();
                    if (allPackageNames.contains(nametoadd)) continue;
                    allPackageNames.add(nametoadd);
                }
            }
            if ("json".equals(this.format)) {
                docsGenerator = new JSONGenerator();
            } else if ("properties".equals(this.format)) {
                docsGenerator = new PropertiesGenerator();
            } else {
                throw new BuildException("Unknown format: '" + this.format + "'");
            }
            Object prepared = docsGenerator.prepareOutputData(YamlFiles, this.version, this.packagename);
            if (!prepared.outputDataAvailable()) {
                this.log("No output could be generated");
                return;
            }
            docsGenerator.write((JSONPrepared)prepared, outputFolder);
        }
        catch (UnsupportedEncodingException e) {
            throw new BuildException("An error occured: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new BuildException("An error occured: " + e.getMessage());
        }
        catch (IOException e) {
            throw new BuildException("An error occured: " + e.getMessage());
        }
    }

    private static boolean isNullOrEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().length() == 0;
    }
}

