/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxCollaboration;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxGroupIterator;
import com.box.sdk.BoxGroupMembership;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

@BoxResourceType(value="group")
public class BoxGroup
extends BoxCollaborator {
    private static final URLTemplate GROUPS_URL_TEMPLATE = new URLTemplate("groups");
    private static final URLTemplate GROUP_URL_TEMPLATE = new URLTemplate("groups/%s");
    private static final URLTemplate MEMBERSHIPS_URL_TEMPLATE = new URLTemplate("groups/%s/memberships");
    private static final URLTemplate ADD_MEMBERSHIP_URL_TEMPLATE = new URLTemplate("group_memberships");
    private static final URLTemplate COLLABORATIONS_URL_TEMPLATE = new URLTemplate("groups/%s/collaborations");

    public BoxGroup(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info createGroup(BoxAPIConnection api, String name) {
        return BoxGroup.createGroup(api, name, null, null, null, null, null);
    }

    public static Info createGroup(BoxAPIConnection api, String name, String provenance, String externalSyncIdentifier, String description, String invitabilityLevel, String memberViewabilityLevel) {
        BoxGroup group;
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("name", name);
        if (provenance != null) {
            requestJSON.add("provenance", provenance);
        }
        if (externalSyncIdentifier != null) {
            requestJSON.add("external_sync_identifier", externalSyncIdentifier);
        }
        if (description != null) {
            requestJSON.add("description", description);
        }
        if (invitabilityLevel != null) {
            requestJSON.add("invitability_level", invitabilityLevel);
        }
        if (memberViewabilityLevel != null) {
            requestJSON.add("member_viewability_level", memberViewabilityLevel);
        }
        URL url = GROUPS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxGroup boxGroup = group = new BoxGroup(api, responseJSON.get("id").asString());
        boxGroup.getClass();
        return boxGroup.new Info(responseJSON);
    }

    public static Iterable<Info> getAllGroups(final BoxAPIConnection api) {
        return new Iterable<Info>(){

            @Override
            public Iterator<Info> iterator() {
                URL url = GROUPS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
                return new BoxGroupIterator(api, url);
            }
        };
    }

    public Info getInfo() {
        URL url = GROUP_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        return new Info(responseJSON);
    }

    public Collection<BoxGroupMembership.Info> getMemberships() {
        BoxAPIConnection api = this.getAPI();
        URL url = MEMBERSHIPS_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        int entriesCount = responseJSON.get("total_count").asInt();
        ArrayList<BoxGroupMembership.Info> memberships = new ArrayList<BoxGroupMembership.Info>(entriesCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue entry : entries) {
            BoxGroupMembership membership;
            JsonObject entryObject = entry.asObject();
            BoxGroupMembership boxGroupMembership = membership = new BoxGroupMembership(api, entryObject.get("id").asString());
            boxGroupMembership.getClass();
            BoxGroupMembership.Info info = new BoxGroupMembership.Info(boxGroupMembership, entryObject);
            memberships.add(info);
        }
        return memberships;
    }

    public BoxGroupMembership.Info addMembership(BoxUser user) {
        return this.addMembership(user, null);
    }

    public BoxGroupMembership.Info addMembership(BoxUser user, BoxGroupMembership.Role role) {
        BoxGroupMembership membership;
        BoxAPIConnection api = this.getAPI();
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("user", (JsonValue)new JsonObject().add("id", user.getID()));
        requestJSON.add("group", (JsonValue)new JsonObject().add("id", this.getID()));
        if (role != null) {
            requestJSON.add("role", role.toJSONString());
        }
        URL url = ADD_MEMBERSHIP_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxGroupMembership boxGroupMembership = membership = new BoxGroupMembership(api, responseJSON.get("id").asString());
        boxGroupMembership.getClass();
        return new BoxGroupMembership.Info(boxGroupMembership, responseJSON);
    }

    public Collection<BoxCollaboration.Info> getCollaborations() {
        BoxAPIConnection api = this.getAPI();
        URL url = COLLABORATIONS_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        int entriesCount = responseJSON.get("total_count").asInt();
        ArrayList<BoxCollaboration.Info> collaborations = new ArrayList<BoxCollaboration.Info>(entriesCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue entry : entries) {
            BoxCollaboration collaboration;
            JsonObject entryObject = entry.asObject();
            BoxCollaboration boxCollaboration = collaboration = new BoxCollaboration(api, entryObject.get("id").asString());
            boxCollaboration.getClass();
            BoxCollaboration.Info info = boxCollaboration.new BoxCollaboration.Info(entryObject);
            collaborations.add(info);
        }
        return collaborations;
    }

    public void delete() {
        URL url = GROUP_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public class Info
    extends BoxCollaborator.Info {
        private String provenance;
        private String externalSyncIdentifier;
        private String description;
        private String invitabilityLevel;
        private String memberViewabilityLevel;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxGroup getResource() {
            return BoxGroup.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            if (memberName.equals("description")) {
                this.description = value.asString();
            } else if (memberName.equals("external_sync_identifier")) {
                this.externalSyncIdentifier = value.asString();
            } else if (memberName.equals("invitability_level")) {
                this.invitabilityLevel = value.asString();
            } else if (memberName.equals("member_viewability_level")) {
                this.memberViewabilityLevel = value.asString();
            } else if (memberName.equals("provenance")) {
                this.provenance = value.asString();
            }
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
            this.addPendingChange("description", description);
        }

        public String getExternalSyncIdentifier() {
            return this.externalSyncIdentifier;
        }

        public void setExternalSyncIdentifier(String externalSyncIdentifier) {
            this.externalSyncIdentifier = externalSyncIdentifier;
            this.addPendingChange("external_sync_identifier", externalSyncIdentifier);
        }

        public String getInvitabilityLevel() {
            return this.invitabilityLevel;
        }

        public void setInvitabilityLevel(String invitabilityLevel) {
            this.invitabilityLevel = invitabilityLevel;
            this.addPendingChange("invitability_level", invitabilityLevel);
        }

        public String getMemberViewabilityLevel() {
            return this.memberViewabilityLevel;
        }

        public void setMemberViewabilityLevel(String memberViewabilityLevel) {
            this.memberViewabilityLevel = memberViewabilityLevel;
            this.addPendingChange("member_viewability_level", memberViewabilityLevel);
        }

        public String getProvenance() {
            return this.provenance;
        }

        public void setProvenance(String provenance) {
            this.provenance = provenance;
            this.addPendingChange("provenance", provenance);
        }
    }
}

