/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.internal.networking.SocketWriter;
import com.hazelcast.internal.networking.SocketWriterInitializer;
import com.hazelcast.internal.networking.WriteHandler;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Protocols;
import java.nio.ByteBuffer;

class ClientSocketWriterInitializer
implements SocketWriterInitializer<ClientConnection> {
    private final int bufferSize;
    private final boolean direct;

    ClientSocketWriterInitializer(int bufferSize, boolean direct) {
        this.bufferSize = bufferSize;
        this.direct = direct;
    }

    @Override
    public void init(ClientConnection connection, SocketWriter writer, String protocol) {
        Logger.getLogger(this.getClass()).fine("Initializing ClientSocketWriter WriteHandler with " + Protocols.toUserFriendlyString(protocol));
        writer.initOutputBuffer(IOUtil.newByteBuffer(this.bufferSize, this.direct));
        writer.initWriteHandler(new WriteHandler<ClientMessage>(){

            @Override
            public boolean onWrite(ClientMessage msg, ByteBuffer dst) throws Exception {
                return msg.writeTo(dst);
            }
        });
    }
}

