/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.logging.AbstractLogger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LogListener;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggerFactory;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class ClientLoggingService
implements LoggingService {
    private final String groupName;
    private final ConcurrentMap<String, ILogger> mapLoggers = new ConcurrentHashMap<String, ILogger>(100);
    private final ConstructorFunction<String, ILogger> loggerConstructor = new ConstructorFunction<String, ILogger>(){

        @Override
        public ILogger createNew(String key) {
            return new DefaultLogger(key);
        }
    };
    private final LoggerFactory loggerFactory;
    private final BuildInfo buildInfo;
    private final String clientName;

    public ClientLoggingService(String groupName, String loggingType, BuildInfo buildInfo, String clientName) {
        this.groupName = groupName;
        this.clientName = clientName;
        this.loggerFactory = Logger.newLoggerFactory(loggingType);
        this.buildInfo = buildInfo;
    }

    @Override
    public void addLogListener(Level level, LogListener logListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeLogListener(LogListener logListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ILogger getLogger(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.mapLoggers, name, this.loggerConstructor);
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.mapLoggers, clazz.getName(), this.loggerConstructor);
    }

    private class DefaultLogger
    extends AbstractLogger {
        final String name;
        final ILogger logger;

        DefaultLogger(String name) {
            this.name = name;
            this.logger = ClientLoggingService.this.loggerFactory.getLogger(name);
        }

        @Override
        public void log(Level level, String message) {
            this.log(level, message, null);
        }

        @Override
        public void log(Level level, String message, Throwable thrown) {
            if (this.logger.isLoggable(level)) {
                String logMessage = ClientLoggingService.this.clientName + " [" + ClientLoggingService.this.groupName + "] [" + ClientLoggingService.this.buildInfo.getVersion() + "] " + message;
                this.logger.log(level, logMessage, thrown);
            }
        }

        @Override
        public void log(LogEvent logEvent) {
        }

        @Override
        public Level getLevel() {
            return this.logger.getLevel();
        }

        @Override
        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }
    }
}

