/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.map.MapPartitionLostEvent;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.PortableMapPartitionLostEvent;
import java.io.IOException;
import java.security.Permission;

public class MapAddPartitionLostListenerRequest
extends CallableClientRequest
implements RetryableRequest {
    private String name;

    public MapAddPartitionLostListenerRequest() {
    }

    public MapAddPartitionLostListenerRequest(String name) {
        this.name = name;
    }

    public Object call() {
        final ClientEndpoint endpoint = this.getEndpoint();
        MapService mapService = (MapService)this.getService();
        MapPartitionLostListener listener = new MapPartitionLostListener(){

            @Override
            public void partitionLost(MapPartitionLostEvent event) {
                if (endpoint.isAlive()) {
                    PortableMapPartitionLostEvent portableEvent = new PortableMapPartitionLostEvent(event.getPartitionId(), event.getMember().getUuid());
                    endpoint.sendEvent(null, portableEvent, MapAddPartitionLostListenerRequest.this.getCallId());
                }
            }
        };
        String registrationId = mapService.getMapServiceContext().addPartitionLostListener(listener, this.name);
        endpoint.addListenerDestroyAction("hz:impl:mapService", this.name, registrationId);
        return registrationId;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("name", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("name");
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public String getMethodName() {
        return "addPartitionLostListener";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 51;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "listen");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{null};
    }
}

