/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Collection;

final class ClearReplicaOperation
extends AbstractOperation
implements PartitionAwareOperation,
MigrationCycleOperation {
    ClearReplicaOperation() {
    }

    @Override
    public void run() throws Exception {
        int partitionId = this.getPartitionId();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Collection<MigrationAwareService> services = nodeEngine.getServices(MigrationAwareService.class);
        for (MigrationAwareService service : services) {
            try {
                service.clearPartitionReplica(partitionId);
            }
            catch (Throwable e) {
                this.logMigrationError(e);
            }
        }
        InternalPartitionService partitionService = (InternalPartitionService)this.getService();
        partitionService.clearPartitionReplicaVersions(partitionId);
    }

    private void logMigrationError(Throwable e) {
        ILogger logger = this.getLogger();
        logger.warning("While clearing partition data: " + this.getPartitionId(), e);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

