/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.txn.TransactionContextProxy;
import com.hazelcast.client.txn.proxy.ClientTxnProxy;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.client.TxnOfferRequest;
import com.hazelcast.queue.client.TxnPeekRequest;
import com.hazelcast.queue.client.TxnPollRequest;
import com.hazelcast.queue.client.TxnSizeRequest;
import java.util.concurrent.TimeUnit;

public class ClientTxnQueueProxy<E>
extends ClientTxnProxy
implements TransactionalQueue<E> {
    public ClientTxnQueueProxy(String name, TransactionContextProxy proxy) {
        super(name, proxy);
    }

    @Override
    public boolean offer(E e) {
        try {
            return this.offer(e, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e1) {
            return false;
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Data data = this.toData(e);
        TxnOfferRequest request = new TxnOfferRequest(this.getName(), unit.toMillis(timeout), data);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public E poll() {
        try {
            return this.poll(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        TxnPollRequest request = new TxnPollRequest(this.getName(), unit.toMillis(timeout));
        return (E)this.invoke(request);
    }

    @Override
    public E peek() {
        try {
            return this.peek(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public E peek(long timeout, TimeUnit unit) throws InterruptedException {
        TxnPeekRequest request = new TxnPeekRequest(this.getName(), unit.toMillis(timeout));
        return (E)this.invoke(request);
    }

    @Override
    public int size() {
        TxnSizeRequest request = new TxnSizeRequest(this.getName());
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public String getName() {
        return (String)this.getId();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    void onDestroy() {
    }
}

