/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.docu.parser;

import com.openexchange.config.docu.parser.DocumentationGenerator;
import com.openexchange.config.docu.parser.JSONGenerator;
import com.openexchange.config.docu.parser.JSONPrepared;
import com.openexchange.config.docu.parser.Parser;
import com.openexchange.config.docu.parser.PropertiesGenerator;
import com.openexchange.config.docu.parser.Property;
import com.openexchange.config.docu.parser.YamlFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    public static void main(String[] args) {
        File outputFolder;
        CommandLine cmd;
        Options options = new Options();
        Option input = new Option("i", "input", true, "specifies the input file path");
        input.setRequired(true);
        options.addOption(input);
        Option output = new Option("o", "output", true, "specifies the output file path");
        output.setRequired(true);
        options.addOption(output);
        Option version = new Option("v", "version", true, "specifies the version");
        version.setRequired(true);
        options.addOption(version);
        Option format = new Option("f", "format", true, "specifies the output format, only 'json'(default) or 'properties' are valid");
        format.setRequired(false);
        options.addOption(format);
        Option chpackage = new Option("p", "package", true, "specifies the package the output should be limited to");
        chpackage.setRequired(false);
        options.addOption(chpackage);
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("options shortcuts", options);
            System.exit(1);
            return;
        }
        String inputFilePath = cmd.getOptionValue("input");
        String outputFilePath = cmd.getOptionValue("output");
        String chosenVersion = cmd.getOptionValue("version");
        String chosenFormat = cmd.getOptionValue("format", "json");
        String chosenPackage = cmd.getOptionValue("package");
        File yamlFolder = new File(inputFilePath);
        if (!yamlFolder.exists() || !yamlFolder.isDirectory()) {
            System.out.println("Input Folder doesn't exist or is not a folder!");
            System.exit(2);
        }
        if (!(outputFolder = new File(outputFilePath)).exists() || !outputFolder.isDirectory()) {
            System.out.println("Output Folder doesn't exist or is not a folder!");
            System.exit(2);
        }
        if (!chosenFormat.equals("json") && !chosenFormat.equals("properties")) {
            System.out.println("Invalid output format '" + chosenFormat + "'");
            formatter.printHelp("options shortcuts", options);
            System.exit(2);
        }
        try {
            DocumentationGenerator<JSONPrepared> docsGenerator;
            LinkedList<String> allPackageNames = new LinkedList<String>();
            List<YamlFile> YamlFiles = Parser.getYamlData(inputFilePath);
            for (YamlFile yamlfile : YamlFiles) {
                for (Property propertie : yamlfile.getProperties()) {
                    String nametoadd = propertie.getPackageName();
                    if (allPackageNames.contains(nametoadd)) continue;
                    allPackageNames.add(nametoadd);
                }
            }
            if ("json".equals(chosenFormat)) {
                docsGenerator = new JSONGenerator();
            } else if ("properties".equals(chosenFormat)) {
                docsGenerator = new PropertiesGenerator();
            } else {
                throw new Exception("Unknown format: '" + chosenFormat + "'");
            }
            Object prepared = docsGenerator.prepareOutputData(YamlFiles, chosenVersion, chosenPackage);
            if (!prepared.outputDataAvailable()) {
                System.out.println("No output could be generated !");
                return;
            }
            docsGenerator.write((JSONPrepared)prepared, outputFolder);
        }
        catch (UnsupportedEncodingException e) {
            Main.error(e);
        }
        catch (FileNotFoundException e) {
            Main.error(e);
        }
        catch (IOException e) {
            Main.error(e);
        }
        catch (Exception e) {
            Main.error(e);
        }
    }

    private static final void error(Exception e) {
        System.out.println("An error occured: " + e.getMessage());
        System.exit(3);
    }

    public static boolean del(File dir) {
        if (dir.isDirectory()) {
            File[] files;
            for (File actFile : files = dir.listFiles()) {
                Main.del(actFile);
            }
        }
        return dir.delete();
    }
}

