/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.auth;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class TokenFromOAuth1Arg {
    protected final String oauth1Token;
    protected final String oauth1TokenSecret;

    public TokenFromOAuth1Arg(String oauth1Token, String oauth1TokenSecret) {
        if (oauth1Token == null) {
            throw new IllegalArgumentException("Required value for 'oauth1Token' is null");
        }
        if (oauth1Token.length() < 1) {
            throw new IllegalArgumentException("String 'oauth1Token' is shorter than 1");
        }
        this.oauth1Token = oauth1Token;
        if (oauth1TokenSecret == null) {
            throw new IllegalArgumentException("Required value for 'oauth1TokenSecret' is null");
        }
        if (oauth1TokenSecret.length() < 1) {
            throw new IllegalArgumentException("String 'oauth1TokenSecret' is shorter than 1");
        }
        this.oauth1TokenSecret = oauth1TokenSecret;
    }

    public String getOauth1Token() {
        return this.oauth1Token;
    }

    public String getOauth1TokenSecret() {
        return this.oauth1TokenSecret;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.oauth1Token, this.oauth1TokenSecret});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            TokenFromOAuth1Arg other = (TokenFromOAuth1Arg)obj;
            return !(this.oauth1Token != other.oauth1Token && !this.oauth1Token.equals(other.oauth1Token) || this.oauth1TokenSecret != other.oauth1TokenSecret && !this.oauth1TokenSecret.equals(other.oauth1TokenSecret));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TokenFromOAuth1Arg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TokenFromOAuth1Arg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("oauth1_token");
            StoneSerializers.string().serialize(value.oauth1Token, g);
            g.writeFieldName("oauth1_token_secret");
            StoneSerializers.string().serialize(value.oauth1TokenSecret, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TokenFromOAuth1Arg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_oauth1TokenSecret;
            String f_oauth1Token;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_oauth1Token = null;
                f_oauth1TokenSecret = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("oauth1_token".equals(field)) {
                        f_oauth1Token = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("oauth1_token_secret".equals(field)) {
                        f_oauth1TokenSecret = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_oauth1Token == null) {
                    throw new JsonParseException(p, "Required field \"oauth1_token\" missing.");
                }
                if (f_oauth1TokenSecret == null) {
                    throw new JsonParseException(p, "Required field \"oauth1_token_secret\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TokenFromOAuth1Arg value = new TokenFromOAuth1Arg(f_oauth1Token, f_oauth1TokenSecret);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

