/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.StringUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.web.ClusteredSessionService;
import com.hazelcast.web.HazelcastHttpSession;
import com.hazelcast.web.LocalCacheEntry;
import com.hazelcast.web.WebFilterConfig;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WebFilter
implements Filter {
    public static final String WEB_FILTER_ATTRIBUTE_KEY = WebFilter.class.getName();
    protected static final ILogger LOGGER = Logger.getLogger(WebFilter.class);
    protected static final LocalCacheEntry NULL_ENTRY = new LocalCacheEntry(false);
    protected ServletContext servletContext;
    private final Properties properties;
    private final ConcurrentMap<String, String> originalSessions = new ConcurrentHashMap<String, String>(1000);
    private final ConcurrentMap<String, HazelcastHttpSession> sessions = new ConcurrentHashMap<String, HazelcastHttpSession>(1000);
    private ClusteredSessionService clusteredSessionService;
    private WebFilterConfig config;

    public WebFilter() {
        this.properties = null;
    }

    public WebFilter(Properties properties) {
        this.properties = properties;
    }

    void destroyOriginalSession(HttpSession originalSession) {
        HazelcastHttpSession hazelSession;
        String hazelcastSessionId = (String)this.originalSessions.remove(originalSession.getId());
        if (hazelcastSessionId != null && (hazelSession = (HazelcastHttpSession)this.sessions.get(hazelcastSessionId)) != null) {
            this.destroySession(hazelSession, false);
        }
    }

    public ClusteredSessionService getClusteredSessionService() {
        return this.clusteredSessionService;
    }

    private static String generateSessionId() {
        char[] chars;
        String id = UuidUtil.newSecureUuidString();
        StringBuilder sb = new StringBuilder("HZ");
        for (char c : chars = id.toCharArray()) {
            if (c == '-') continue;
            if (Character.isLetter(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        this.config = WebFilterConfig.create(filterConfig, this.properties);
        this.servletContext = filterConfig.getServletContext();
        this.servletContext.setAttribute(WEB_FILTER_ATTRIBUTE_KEY, (Object)this);
        this.clusteredSessionService = new ClusteredSessionService(this.config);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(this.config.toString());
        }
    }

    private boolean sessionExistsInTheCluster(String hazelcastSessionId) {
        try {
            return hazelcastSessionId != null && this.clusteredSessionService.containsSession(hazelcastSessionId);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    protected HazelcastHttpSession createNewSession(HazelcastRequestWrapper requestWrapper, String existingSessionId) {
        String id;
        String string = id = this.sessionExistsInTheCluster(existingSessionId) ? existingSessionId : WebFilter.generateSessionId();
        if (requestWrapper.getOriginalSession(false) != null) {
            LOGGER.finest("Original session exists!!!");
        }
        HttpSession originalSession = requestWrapper.getOriginalSession(true);
        HazelcastHttpSession hazelcastSession = this.createHazelcastHttpSession(id, originalSession);
        if (existingSessionId == null) {
            hazelcastSession.setClusterWideNew(true);
        }
        this.updateSessionMaps(id, originalSession, hazelcastSession);
        this.addSessionCookie(requestWrapper, id);
        return hazelcastSession;
    }

    protected HazelcastHttpSession createHazelcastHttpSession(String id, HttpSession originalSession) {
        return new HazelcastHttpSession(this, id, originalSession, this.config.isDeferredWrite(), this.config.isStickySession(), this.config.getTransientAttributes());
    }

    private void updateSessionMaps(String sessionId, HttpSession originalSession, HazelcastHttpSession hazelcastSession) {
        this.sessions.put(hazelcastSession.getId(), hazelcastSession);
        String oldHazelcastSessionId = this.originalSessions.put(originalSession.getId(), hazelcastSession.getId());
        if (LOGGER.isFinestEnabled()) {
            if (oldHazelcastSessionId != null) {
                LOGGER.finest("!!! Overwrote an existing hazelcastSessionId " + oldHazelcastSessionId);
            }
            LOGGER.finest("Created new session with id: " + sessionId);
            LOGGER.finest(this.sessions.size() + " is sessions.size and originalSessions.size: " + this.originalSessions.size());
        }
    }

    protected void destroySession(HazelcastHttpSession session, boolean invalidate) {
        if (LOGGER.isFinestEnabled()) {
            LOGGER.finest("Destroying local session: " + session.getId());
        }
        this.sessions.remove(session.getId());
        this.originalSessions.remove(session.getOriginalSession().getId());
        session.destroy(invalidate);
    }

    private HazelcastHttpSession getSessionWithId(String sessionId) {
        HazelcastHttpSession session = (HazelcastHttpSession)this.sessions.get(sessionId);
        if (session != null && !session.isValid()) {
            this.destroySession(session, true);
            session = null;
        }
        return session;
    }

    private void addSessionCookie(HazelcastRequestWrapper req, String sessionId) {
        Cookie sessionCookie = new Cookie(this.config.getCookieName(), sessionId);
        String path = !StringUtil.isNullOrEmptyAfterTrim(this.config.getCookiePath()) ? this.config.getCookiePath() : req.getContextPath();
        if ("".equals(path)) {
            path = "/";
        }
        sessionCookie.setPath(path);
        sessionCookie.setMaxAge(-1);
        if (this.config.getCookieDomain() != null) {
            sessionCookie.setDomain(this.config.getCookieDomain());
        }
        if (this.config.isCookieHttpOnly()) {
            try {
                sessionCookie.setHttpOnly(true);
            }
            catch (NoSuchMethodError e) {
                LOGGER.info("HttpOnly cookies require a Servlet 3.0+ container. Add the following to the " + this.getClass().getName() + " mapping in web.xml to disable HttpOnly cookies:\n" + "<init-param>\n" + "    <param-name>cookie-http-only</param-name>\n" + "    <param-value>false</param-value>\n" + "</init-param>");
            }
        }
        sessionCookie.setSecure(this.config.isCookieSecure());
        req.res.addCookie(sessionCookie);
    }

    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HazelcastRequestWrapper requestWrapper = new HazelcastRequestWrapper((HttpServletRequest)req, (HttpServletResponse)res);
        chain.doFilter((ServletRequest)requestWrapper, res);
        HazelcastHttpSession session = requestWrapper.getSession(false);
        if (session != null && session.isValid() && this.config.isDeferredWrite()) {
            if (LOGGER.isFinestEnabled()) {
                LOGGER.finest("UPDATING SESSION " + session.getId());
            }
            session.sessionDeferredWrite();
        }
    }

    public final void destroy() {
        this.sessions.clear();
        this.originalSessions.clear();
        if (this.config.isShutdownOnDestroy()) {
            this.clusteredSessionService.destroy();
        }
    }

    protected class HazelcastRequestWrapper
    extends HttpServletRequestWrapper {
        final HttpServletResponse res;
        HazelcastHttpSession hazelcastSession;

        public HazelcastRequestWrapper(HttpServletRequest req, HttpServletResponse res) {
            super(req);
            this.res = res;
        }

        HttpSession getOriginalSession(boolean create) {
            HttpServletRequest req = (HttpServletRequest)this.getRequest();
            while (req instanceof HttpServletRequestWrapper) {
                req = (HttpServletRequest)((HttpServletRequestWrapper)req).getRequest();
            }
            if (req != null) {
                return req.getSession(create);
            }
            return super.getSession(create);
        }

        public RequestDispatcher getRequestDispatcher(final String path) {
            final ServletRequest original = this.getRequest();
            return new RequestDispatcher(){

                public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    original.getRequestDispatcher(path).forward(servletRequest, servletResponse);
                }

                public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    original.getRequestDispatcher(path).include(servletRequest, servletResponse);
                }
            };
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public HazelcastHttpSession getSession(boolean create) {
            this.hazelcastSession = this.readSessionFromLocal();
            String hazelcastSessionId = this.findHazelcastSessionIdFromRequest();
            if (this.hazelcastSession == null && !this.res.isCommitted() && (create || hazelcastSessionId != null)) {
                this.hazelcastSession = WebFilter.this.createNewSession(this, hazelcastSessionId);
            }
            return this.hazelcastSession;
        }

        private HazelcastHttpSession readSessionFromLocal() {
            String invalidatedOriginalSessionId = null;
            if (this.hazelcastSession != null && !this.hazelcastSession.isValid()) {
                LOGGER.finest("Session is invalid!");
                WebFilter.this.destroySession(this.hazelcastSession, true);
                invalidatedOriginalSessionId = this.hazelcastSession.invalidatedOriginalSessionId;
                this.hazelcastSession = null;
            } else if (this.hazelcastSession != null) {
                return this.hazelcastSession;
            }
            HttpSession originalSession = this.getOriginalSession(false);
            if (originalSession != null) {
                String hazelcastSessionId = (String)WebFilter.this.originalSessions.get(originalSession.getId());
                if (hazelcastSessionId != null) {
                    this.hazelcastSession = WebFilter.this.getSessionWithId(hazelcastSessionId);
                    if (this.hazelcastSession != null && !this.hazelcastSession.isStickySession()) {
                        this.hazelcastSession.updateReloadFlag();
                    }
                    return this.hazelcastSession;
                }
                if (!originalSession.getId().equals(invalidatedOriginalSessionId)) {
                    originalSession.invalidate();
                }
            }
            return this.readFromCookie();
        }

        private HazelcastHttpSession readFromCookie() {
            String existingHazelcastSessionId = this.findHazelcastSessionIdFromRequest();
            if (existingHazelcastSessionId != null) {
                this.hazelcastSession = WebFilter.this.getSessionWithId(existingHazelcastSessionId);
                if (this.hazelcastSession != null && !this.hazelcastSession.isStickySession()) {
                    this.hazelcastSession.updateReloadFlag();
                    return this.hazelcastSession;
                }
            }
            return null;
        }

        private String findHazelcastSessionIdFromRequest() {
            String hzSessionId = null;
            Cookie[] cookies = this.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    String name = cookie.getName();
                    String value = cookie.getValue();
                    if (!name.equalsIgnoreCase(WebFilter.this.config.getCookieName())) continue;
                    hzSessionId = value;
                    break;
                }
            }
            if (hzSessionId == null && WebFilter.this.config.isUseRequestParameter()) {
                hzSessionId = this.getParameter(WebFilter.this.config.getCookieName());
            }
            return hzSessionId;
        }
    }
}

