/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.InternalLockNamespace;
import com.hazelcast.concurrent.lock.LockProxy;
import com.hazelcast.concurrent.lock.LockResource;
import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.concurrent.lock.LockStoreContainer;
import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.concurrent.lock.LockStoreInfo;
import com.hazelcast.concurrent.lock.LockStoreProxy;
import com.hazelcast.concurrent.lock.operations.LocalLockCleanupOperation;
import com.hazelcast.concurrent.lock.operations.LockReplicationOperation;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.spi.ClientAwareService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class LockServiceImpl
implements LockService,
ManagedService,
RemoteService,
MembershipAwareService,
MigrationAwareService,
ClientAwareService {
    private final NodeEngine nodeEngine;
    private final LockStoreContainer[] containers;
    private final ConcurrentMap<String, ConstructorFunction<ObjectNamespace, LockStoreInfo>> constructors = new ConcurrentHashMap<String, ConstructorFunction<ObjectNamespace, LockStoreInfo>>();

    public LockServiceImpl(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.containers = new LockStoreContainer[nodeEngine.getPartitionService().getPartitionCount()];
        for (int i = 0; i < this.containers.length; ++i) {
            this.containers[i] = new LockStoreContainer(this, i);
        }
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.registerLockStoreConstructor("hz:impl:lockService", new ConstructorFunction<ObjectNamespace, LockStoreInfo>(){

            @Override
            public LockStoreInfo createNew(ObjectNamespace key) {
                return new LockStoreInfo(){

                    @Override
                    public int getBackupCount() {
                        return 1;
                    }

                    @Override
                    public int getAsyncBackupCount() {
                        return 0;
                    }
                };
            }
        });
    }

    @Override
    public void reset() {
        for (LockStoreContainer container : this.containers) {
            for (LockStoreImpl lockStore : container.getLockStores()) {
                lockStore.clear();
            }
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        for (LockStoreContainer container : this.containers) {
            container.clear();
        }
    }

    @Override
    public void registerLockStoreConstructor(String serviceName, ConstructorFunction<ObjectNamespace, LockStoreInfo> constructorFunction) {
        boolean put;
        boolean bl = put = this.constructors.putIfAbsent(serviceName, constructorFunction) == null;
        if (!put) {
            throw new IllegalArgumentException("LockStore constructor for service[" + serviceName + "] " + "is already registered!");
        }
    }

    ConstructorFunction<ObjectNamespace, LockStoreInfo> getConstructor(String serviceName) {
        return (ConstructorFunction)this.constructors.get(serviceName);
    }

    @Override
    public LockStore createLockStore(int partitionId, ObjectNamespace namespace) {
        LockStoreContainer container = this.getLockContainer(partitionId);
        container.getOrCreateLockStore(namespace);
        return new LockStoreProxy(container, namespace);
    }

    @Override
    public void clearLockStore(int partitionId, ObjectNamespace namespace) {
        LockStoreContainer container = this.getLockContainer(partitionId);
        container.clearLockStore(namespace);
    }

    public LockStoreContainer getLockContainer(int partitionId) {
        return this.containers[partitionId];
    }

    public LockStoreImpl getLockStore(int partitionId, ObjectNamespace namespace) {
        return this.getLockContainer(partitionId).getOrCreateLockStore(namespace);
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        MemberImpl member = event.getMember();
        String uuid = member.getUuid();
        this.releaseLocksOf(uuid);
    }

    @Override
    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    private void releaseLocksOf(String uuid) {
        for (LockStoreContainer container : this.containers) {
            for (LockStoreImpl lockStore : container.getLockStores()) {
                this.releaseLock(uuid, container, lockStore);
            }
        }
    }

    private void releaseLock(String uuid, LockStoreContainer container, LockStoreImpl lockStore) {
        Collection<LockResource> locks = lockStore.getLocks();
        for (LockResource lock : locks) {
            Data key = lock.getKey();
            if (!uuid.equals(lock.getOwner()) || lock.isTransactional()) continue;
            this.sendUnlockOperation(container, lockStore, key);
        }
    }

    private void sendUnlockOperation(LockStoreContainer container, LockStoreImpl lockStore, Data key) {
        LocalLockCleanupOperation op = new LocalLockCleanupOperation(lockStore.getNamespace(), key, -1L);
        op.setAsyncBackup(true);
        op.setNodeEngine(this.nodeEngine);
        op.setServiceName("hz:impl:lockService");
        op.setService(this);
        op.setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
        op.setPartitionId(container.getPartitionId());
        op.setValidateTarget(false);
        this.nodeEngine.getOperationService().executeOperation(op);
    }

    @Override
    public Collection<LockResource> getAllLocks() {
        LinkedList<LockResource> locks = new LinkedList<LockResource>();
        for (LockStoreContainer container : this.containers) {
            for (LockStoreImpl lockStore : container.getLockStores()) {
                locks.addAll(lockStore.getLocks());
            }
        }
        return locks;
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        int replicaIndex;
        int partitionId = event.getPartitionId();
        LockStoreContainer container = this.containers[partitionId];
        LockReplicationOperation op = new LockReplicationOperation(container, partitionId, replicaIndex = event.getReplicaIndex());
        if (op.isEmpty()) {
            return null;
        }
        return op;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearPartition(event.getPartitionId());
        } else {
            int partitionId = event.getPartitionId();
            this.scheduleEvictions(partitionId);
        }
    }

    private void scheduleEvictions(int partitionId) {
        long now = Clock.currentTimeMillis();
        LockStoreContainer container = this.containers[partitionId];
        for (LockStoreImpl ls : container.getLockStores()) {
            for (LockResource lock : ls.getLocks()) {
                long expirationTime = lock.getExpirationTime();
                if (expirationTime == Long.MAX_VALUE || expirationTime < 0L) continue;
                long leaseTime = expirationTime - now;
                ls.scheduleEviction(lock.getKey(), 0, leaseTime);
            }
        }
    }

    private void clearPartition(int partitionId) {
        LockStoreContainer container = this.containers[partitionId];
        for (LockStoreImpl ls : container.getLockStores()) {
            ls.clear();
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearPartition(event.getPartitionId());
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.clearPartition(partitionId);
    }

    @Override
    public DistributedObject createDistributedObject(String objectId) {
        return new LockProxy(this.nodeEngine, this, objectId);
    }

    @Override
    public void destroyDistributedObject(String objectId) {
        Object key = this.nodeEngine.getSerializationService().toData(objectId);
        for (LockStoreContainer container : this.containers) {
            InternalLockNamespace namespace = new InternalLockNamespace(objectId);
            LockStoreImpl lockStore = container.getOrCreateLockStore(namespace);
            lockStore.forceUnlock((Data)key);
        }
    }

    @Override
    public void clientDisconnected(String clientUuid) {
        this.releaseLocksOf(clientUuid);
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }
}

