/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapreduce.impl;

import com.hazelcast.mapreduce.JobPartitionState;
import com.hazelcast.mapreduce.impl.task.JobPartitionStateImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;

public class JobPartitionStateArraySerializerHook
implements SerializerHook<JobPartitionState[]> {
    @Override
    public Class<JobPartitionState[]> getSerializationType() {
        return JobPartitionState[].class;
    }

    @Override
    public Serializer createSerializer() {
        return new JobPartitionStateArraySerializer();
    }

    @Override
    public boolean isOverwritable() {
        return false;
    }

    private static class JobPartitionStateArraySerializer
    implements StreamSerializer<JobPartitionState[]> {
        private JobPartitionStateArraySerializer() {
        }

        @Override
        public void write(ObjectDataOutput out, JobPartitionState[] partitionStates) throws IOException {
            out.writeBoolean(partitionStates != null);
            if (partitionStates != null) {
                out.writeInt(partitionStates.length);
                for (JobPartitionState partitionState : partitionStates) {
                    out.writeBoolean(partitionState != null);
                    if (partitionState == null) continue;
                    out.writeObject(partitionState.getOwner());
                    out.writeInt(partitionState.getState().ordinal());
                }
            }
        }

        @Override
        public JobPartitionState[] read(ObjectDataInput in) throws IOException {
            if (in.readBoolean()) {
                int length = in.readInt();
                JobPartitionState[] partitionStates = new JobPartitionState[length];
                for (int i = 0; i < length; ++i) {
                    if (!in.readBoolean()) continue;
                    Address owner = (Address)in.readObject();
                    JobPartitionState.State state = JobPartitionState.State.byOrdinal(in.readInt());
                    partitionStates[i] = new JobPartitionStateImpl(owner, state);
                }
                return partitionStates;
            }
            return null;
        }

        @Override
        public int getTypeId() {
            return -102;
        }

        @Override
        public void destroy() {
        }
    }
}

