/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.imagemgr;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

/**
 * {@link ResourceLocker}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
class ResourceLocker {

    static final long TOUCH_RESOURCE_TIMER_PERIOD = 60000;

    /**
     * Initializes a new {@link ResourceLocker}.
     */
    ResourceLocker() {
        super();

        // create the task to touch the held resources at at specified interval
        m_timerTask = new TimerTask() {

            @Override
            public void run() {
                final HashSet<ResourceManager> resourceManagers = getResourceManagers();

                synchronized (resourceManagers) {
                    // touch each collected resource
                    for (final Iterator<ResourceManager> resourceManagerIter = resourceManagers.iterator(); resourceManagerIter.hasNext();) {
                        resourceManagerIter.next().touch();
                    }
                }
            }
        };

        // start the periodic timer with the specified timeout
        m_timer.schedule(m_timerTask, TOUCH_RESOURCE_TIMER_PERIOD, TOUCH_RESOURCE_TIMER_PERIOD);
    }

    /**
     * @return
     */
    HashSet<ResourceManager> getResourceManagers() {
        return m_resourceManagers;
    }

    /**
     * @param resourceManager
     */
    void lockResourceManager(ResourceManager resourceManager, boolean lock) {
        if (null != resourceManager) {
            synchronized (m_resourceManagers) {
                if (lock && !m_resourceManagers.contains(resourceManager)) {
                    m_resourceManagers.add(resourceManager);
                } else if (!lock && m_resourceManagers.contains(resourceManager)) {
                    m_resourceManagers.remove(resourceManager);
                }
            }
        }
    }

    // - Members -----------------------------------------------------------

    private final Timer m_timer = new Timer("com.openexchange.office.tools.ResourceLocker");

    private TimerTask m_timerTask = null;

    private final HashSet<ResourceManager> m_resourceManagers = new HashSet<ResourceManager>();
}
