/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.docx.components;

import javax.xml.bind.JAXBException;
import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.wml.CTSdtCell;
import org.docx4j.wml.CTTrPrBase;
import org.docx4j.wml.CTTrPrChange;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.ooxml.components.Component;
import com.openexchange.office.filter.ooxml.components.ComponentContext;
import com.openexchange.office.filter.ooxml.components.IRow;
import com.openexchange.office.filter.ooxml.docx.tools.Table;
import com.openexchange.office.filter.ooxml.docx.tools.Utils;

public class TrComponent extends DocxComponent implements IRow {

    public TrComponent(ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);
    }
    @Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        final IndexedNode<Object> trNode = getNode();
        final IndexedNodeList<Object> nodeList = (IndexedNodeList<Object>)((ContentAccessor)trNode.getData()).getContent();
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;
        final int nextGridPosition = previousChildComponent instanceof TcComponent?((TcComponent)previousChildComponent).getNextGridPosition():0;
        IndexedNode<Object> childNode = previousChildContext!=null ? nodeList.getNextNode(previousChildContext.getNode()) : nodeList.getFirstNode();

        Component nextComponent = null;
        for(; nextComponent==null&&childNode!=null; childNode = nodeList.getNextNode(childNode)) {
            final Object o = getContentModel(childNode, trNode.getData());
            if(o instanceof Tc) {
                nextComponent = new TcComponent(this, childNode, nextComponentNumber, nextGridPosition);
            }
            else if(o instanceof CTSdtCell) {
                final SdtRowContext sdtRowContext = new SdtRowContext(this, childNode);
                nextComponent = sdtRowContext.getNextChildComponent(null, previousChildComponent);
            }
        }
        return nextComponent;
    }
	@Override
	public void applyAttrsFromJSON(JSONObject attrs) {
		if(attrs==null) {
			return;
		}
		try {
	        final Tr tr = (Tr)getObject();
	        final TrPr trPr = tr.getTrPr(true);
	        Table.applyRowProperties(attrs.optJSONObject(OCKey.ROW.value()), trPr);
	        final Object changes = attrs.opt(OCKey.CHANGES.value());
	        if(changes!=null) {
		        if(changes instanceof JSONObject) {
		        	final Object attrsInserted = ((JSONObject)changes).opt(OCKey.INSERTED.value());
		        	if(attrsInserted!=null) {
		        		if(attrsInserted instanceof JSONObject) {
                			Utils.applyTrackInfoFromJSON((com.openexchange.office.filter.ooxml.docx.DocxOperationDocument)operationDocument, (JSONObject)attrsInserted, trPr.getIns(true));
		        		}
		        		else {
		        			trPr.setIns(null);
		        		}
		        	}
		        	final Object attrsRemoved = ((JSONObject)changes).opt(OCKey.REMOVED.value());
		        	if(attrsRemoved!=null) {
			        	if(attrsRemoved instanceof JSONObject) {
                			Utils.applyTrackInfoFromJSON((com.openexchange.office.filter.ooxml.docx.DocxOperationDocument)operationDocument, (JSONObject)attrsRemoved, trPr.getDel(true));
			        	}
			        	else {
			        		trPr.setDel(null);
			        	}
		        	}
		        	final Object attrsModified = ((JSONObject)changes).opt(OCKey.MODIFIED.value());
		        	if(attrsModified!=null) {
		        		if(attrsModified instanceof JSONObject) {
		        		    final CTTrPrChange trPrChange = trPr.getTrPrChange(true);
		        			Utils.applyTrackInfoFromJSON((com.openexchange.office.filter.ooxml.docx.DocxOperationDocument)operationDocument, (JSONObject)attrsModified, trPrChange);
        					final Object attrsModifiedAttrs = ((JSONObject)attrsModified).opt(OCKey.ATTRS.value());
        					if(attrsModifiedAttrs!=null) {
        						if(attrsModifiedAttrs instanceof JSONObject) {
        							Table.applyRowProperties(((JSONObject)attrsModifiedAttrs).optJSONObject(OCKey.ROW.value()), trPrChange.getTrPr(true));
        						}
        						else {
        							trPrChange.setTrPr(null);
        						}
        					}
		        		}
		        		else {
		        			trPr.setTrPrChange(null);
		        		}
		        	}
		        }
		        else {
		        	trPr.setIns(null);
		        	trPr.setDel(null);
		        	trPr.setTrPrChange(null);
		        }
	        }
		}
		catch(Exception e) {

		}
	}

	@Override
	public JSONObject createJSONAttrs(JSONObject attrs)
		throws JSONException {

		final Tr tr = (Tr)getObject();
        final TrPr trPr = tr.getTrPr(false);
        if(trPr!=null) {
            Table.createRowProperties(tr.getTrPr(false), attrs);
            if(trPr.getDel(false)!=null||trPr.getIns(false)!=null||trPr.getTrPrChange(false)!=null) {
                final JSONObject jsonRowChanges = new JSONObject(2);
                if(trPr.getDel(false)!=null) {
                	jsonRowChanges.put(OCKey.REMOVED.value(), Utils.createJSONFromTrackInfo(getOperationDocument(), trPr.getDel(false)));
                }
                if(trPr.getIns(false)!=null) {
                	jsonRowChanges.put(OCKey.INSERTED.value(), Utils.createJSONFromTrackInfo(getOperationDocument(), trPr.getIns(false)));
                }
                if(trPr.getTrPrChange(false)!=null) {
                	JSONObject rowModified = Utils.createJSONFromTrackInfo(getOperationDocument(), trPr.getTrPrChange(false));
                	final CTTrPrBase trPrChangePr = trPr.getTrPrChange(false).getTrPr(false);
                	if(trPrChangePr!=null) {
                		final JSONObject jsonRowAttrChanges = new JSONObject();
                		Table.createRowProperties(trPrChangePr, jsonRowAttrChanges);
                		if(!jsonRowAttrChanges.isEmpty()) {
                			rowModified.put(OCKey.ATTRS.value(), jsonRowAttrChanges);
                		}
                	}
                	if(!rowModified.isEmpty()) {
                    	jsonRowChanges.put(OCKey.MODIFIED.value(), rowModified);
                	}
                }
                if(!jsonRowChanges.isEmpty()) {
                	attrs.put(OCKey.CHANGES.value(), jsonRowChanges);
                }
            }
        }
        return attrs;
	}

	// IRow interface
	@Override
	public void insertCells(int cellPosition, int count, JSONObject attrs)
	    throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

    	Component c = getChildComponent(cellPosition);
    	final Tr tr = (Tr)getObject();
        final IndexedNodeList<Object> trContent = tr.getContent();
        for (int i=0; i<count; i++) {
            final Tc tc = Context.getWmlObjectFactory().createTc();
            tc.setParent(tr);
            trContent.addNode(c!=null?c.getNode():null, new IndexedNode<Object>(tc), true);
        }
        if(attrs!=null) {
            c = getChildComponent(cellPosition);
            for(int i=0; i<count; i++) {
            	c.applyAttrsFromJSON(attrs);
            	c = c.getNextComponent();
            }
        }
	}
}
