/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.docx.components;

import java.util.List;
import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.wml.Comments;
import org.docx4j.wml.Comments.Comment;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.R;
import org.docx4j.wml.SdtBlock;
import com.openexchange.office.filter.ooxml.components.Component;
import com.openexchange.office.filter.ooxml.components.ComponentContext;
import com.openexchange.office.filter.ooxml.docx.DocxOperationDocument;

public abstract class DocxComponent extends Component {

    public DocxComponent(DocxOperationDocument operationDocument, IndexedNode<Object> _node, int _componentNumber) {
        super(operationDocument, _node, _componentNumber);
    }

    public DocxComponent(ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);
    }

    @Override
    public DocxOperationDocument getOperationDocument() {
        return (DocxOperationDocument)super.getOperationDocument();
    }

    @Override
    public Component insertChildComponent(ComponentContext parentContext, IndexedNode<Object> contextNode, int number, Component child, Type type) {
    	return null;
    }

    @Override
    public void delete(int count)
    	throws InvalidFormatException {

    	final ComponentContext contextChild = getContextChild(null);

    	final int endComponent = (getComponentNumber()+count)-1;
        Component component = this;
        while(true) {
        	if(component instanceof CommentReferenceComponent) {
        		final CommentsPart commentsPart = ((DocxOperationDocument)operationDocument).getCommentsPart(false);
        		if(commentsPart!=null) {
        			final Comments comments = commentsPart.getJaxbElement();
        			if(comments!=null) {
        				final List<Comment> commentList = comments.getComment();
        				for(int i=0; i<commentList.size(); i++) {
        					final Comment comment = commentList.get(i);
        					if(comment.getId().equals(((R.CommentReference)component.getObject()).getId())) {
        						commentList.remove(i);
        						break;
        					}
        				}
        			}
        		}
        	}
        	if(component.getNextComponentNumber()>endComponent) {
        		break;
        	}
        	component = component.getNextComponent();
        }
        component.splitEnd(endComponent, SplitMode.DELETE);
        final IndexedNodeList<Object> content = (IndexedNodeList<Object>)((ContentAccessor)contextChild.getParentContext().getNode().getData()).getContent();
        content.removeNodes(contextChild.getNode(), component.getContextChild(null).getNode());
    }

    @Override
    public void splitStart(int n, SplitMode splitMode) {
        if(!getNode().isFirst()) {
            final ComponentContext pContext = getParentContext();
            if(pContext instanceof SdtRootContext) {
                final IndexedNode<Object> sdtSourceNode = pContext.getNode();
                final SdtBlock sdtSource = (SdtBlock)(sdtSourceNode.getData());
                final SdtBlock sdtDest = Context.getWmlObjectFactory().createSdtBlock();
                sdtDest.setParent(sdtSource.getParent());
                final IndexedNodeList<Object> sdtSourceContent = sdtSource.getContent();
                final IndexedNodeList<Object> sdtDestContent = sdtDest.getContent();
                sdtSourceContent.moveNodes(getNode(), -1, sdtDestContent, null, true, sdtDest);
                final ContentAccessor sdtParent = (ContentAccessor)(pContext.getParentContext().getNode().getData());
                final IndexedNode<Object> sdtDestNode = new IndexedNode<Object>(sdtDest);
                ((IndexedNodeList<Object>)(sdtParent.getContent())).addNode(sdtSourceNode, sdtDestNode, false);
                setParentContext(new SdtRootContext(pContext.getParentContext(), sdtDestNode));
            }
        }
    }

    @Override
    public void splitEnd(int n, SplitMode splitMode) {
        final ComponentContext pContext = getParentContext();
        if(pContext instanceof SdtRootContext) {
            final IndexedNode<Object> sdtSourceNode = pContext.getNode();
            final SdtBlock sdtSource = (SdtBlock)(sdtSourceNode.getData());
            final IndexedNodeList<Object> sdtSourceContent = sdtSource.getContent();
            if(!getNode().isLast(sdtSourceContent)) {
                final SdtBlock sdtDest = Context.getWmlObjectFactory().createSdtBlock();
                sdtDest.setParent(sdtSource.getParent());
                final IndexedNodeList<Object> sdtDestContent = sdtDest.getContent();
                IndexedNode<Object> sourceRefNode = sdtSourceContent.getNextNode(getNode());
                if(sourceRefNode!=null) {
                    sdtSourceContent.moveNodes(sourceRefNode, -1, sdtDestContent, null, true, sdtDest);
                }
                final ContentAccessor sdtParent = (ContentAccessor)(pContext.getParentContext().getNode().getData());
                final IndexedNode<Object> sdtDestNode = new IndexedNode<Object>(sdtDest);
                ((IndexedNodeList<Object>)(sdtParent.getContent())).addNode(sdtSourceNode, sdtDestNode, false);
            }
        }
    }
}
