/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ods.dom.components;

import org.json.JSONObject;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.odf.DLNode;
import com.openexchange.office.filter.odf.OdfOperationDoc;
import com.openexchange.office.filter.odf.OpAttrs;
import com.openexchange.office.filter.odf.components.Component;
import com.openexchange.office.filter.odf.components.ComponentContext;
import com.openexchange.office.filter.odf.draw.CustomShape;
import com.openexchange.office.filter.odf.draw.DrawFrame;
import com.openexchange.office.filter.odf.draw.DrawImage;
import com.openexchange.office.filter.odf.draw.DrawTextBox;
import com.openexchange.office.filter.odf.draw.GroupShape;
import com.openexchange.office.filter.odf.draw.Shape;
import com.openexchange.office.filter.ods.dom.Drawing;
import com.openexchange.office.filter.ods.dom.DrawingAnchor;
import com.openexchange.office.filter.ods.dom.Sheet;

public class SheetComponent extends Component {

    private final Sheet sheet;

    public SheetComponent(ComponentContext parentContext, DLNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);
        this.sheet = (Sheet)getObject();
    }

    public SheetComponent(Sheet sheet, int _componentNumber) {
        super(null, new DLNode<Object>(sheet), _componentNumber);
        this.sheet = (Sheet)getObject();
    }

    @Override
    public String simpleName() {
        return "Sheet";
    }

    @Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        final int nextComponentNumber = previousChildComponent != null ? previousChildComponent.getNextComponentNumber() : 0;
        DLNode<Object> nextNode = previousChildContext != null ? previousChildContext.getNode().next : ((Sheet)getNode().getObject()).getContent().getFirstNode();
        while(nextNode!=null) {
            final Object child = nextNode.getObject();
            if(child instanceof Drawing) {
                return new DrawingComponent(this, nextNode, nextComponentNumber);
            }
            nextNode = nextNode.next;
        }
        return null;
    }

    @Override
    public Component insertChildComponent(OdfOperationDoc operationDocument, ComponentContext parentContext, DLNode<Object> contextNode, int number, Component child, Type type, JSONObject attrs) {

        DLNode<Object> referenceNode = child != null && child.getComponentNumber()== number ? child.getNode() : null;

        switch(type) {
            case AC_SHAPE: {
                final Shape shape = Shape.createShape(operationDocument, attrs, null, true, isContentAutoStyle());
                final Drawing drawing = new Drawing(sheet, new DrawingAnchor(0,0), shape);
                final DLNode<Object> drawingNode = new DLNode<Object>(drawing);
                sheet.getDrawings().addDrawingNode(drawingNode, referenceNode);
                return new DrawingComponent(parentContext, drawingNode, number);
            }
            case AC_CONNECTOR: {
                final Shape shape = new CustomShape(operationDocument, null, true, isContentAutoStyle());
                final Drawing drawing = new Drawing(sheet, new DrawingAnchor(0, 0), shape);
                final DLNode<Object> drawingNode = new DLNode<Object>(drawing);
                sheet.getDrawings().addDrawingNode(drawingNode, referenceNode);
                return new DrawingComponent(parentContext, drawingNode, number);
            }
            case AC_GROUP: {
                final GroupShape groupShape = new GroupShape(operationDocument, null, true, isContentAutoStyle());
                final Drawing drawing = new Drawing(sheet, new DrawingAnchor(0, 0), groupShape);
                final DLNode<Object> drawingNode = new DLNode<Object>(drawing);
                sheet.getDrawings().addDrawingNode(drawingNode, referenceNode);
                return new DrawingComponent(parentContext, drawingNode, number);
            }
            case AC_IMAGE: {
                final DrawFrame drawFrame = new DrawFrame(operationDocument, null, true, isContentAutoStyle());
                final Drawing drawing = new Drawing(sheet, new DrawingAnchor(0, 0), drawFrame);
                final DLNode<Object> drawingNode = new DLNode<Object>(drawing);
                final DrawImage drawImage = new DrawImage(drawFrame);
                drawFrame.addContent(drawImage);
                sheet.getDrawings().addDrawingNode(drawingNode, referenceNode);
                return new DrawingComponent(parentContext, drawingNode, number);
            }
            case AC_FRAME: {
                final DrawFrame drawFrame = new DrawFrame(operationDocument, null, true, isContentAutoStyle());
                final Drawing drawing = new Drawing(sheet, new DrawingAnchor(0, 0), drawFrame);
                final DLNode<Object> drawingNode = new DLNode<Object>(drawing);
                final DrawTextBox drawTextBox = new DrawTextBox(drawFrame);
                drawFrame.addContent(drawTextBox);
                sheet.getDrawings().addDrawingNode(drawingNode, referenceNode);
                return new DrawingComponent(parentContext, drawingNode, number);
            }
            case AC_CHART: {
                final DrawFrame drawFrame = getChart(operationDocument, isContentAutoStyle());
                final Drawing drawing = new Drawing(sheet, new DrawingAnchor(0, 0), drawFrame);
                final DLNode<Object> drawingNode = new DLNode<Object>(drawing);
                sheet.getDrawings().addDrawingNode(drawingNode, referenceNode);
                return new DrawingComponent(parentContext, drawingNode, number);
            }
            default : {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void applyAttrsFromJSON(OdfOperationDoc operationDocument, JSONObject attrs) {

    }

    @Override
    public void createAttrs(OdfOperationDoc createOperationHelper, OpAttrs attrs)
    	throws SAXException {

    }
}
